// @ts-nocheck
// ==== NA Sound ==== 
// ==== NStep ==== 
// ==== 16-STEP MIDI SEQUENCER ====
// ==== Version 1 - December 2025 ====
//
// ------------------------------------------------------------
// ORGANIZATION (mostly)
// 1. Constants and Global State
// 2. Look and feel
// 3. Tempo helpers
// 4. Randomization
// 5. Quantization
// 6. LED helpers
// 7. Start button look
// 8. Sequencer engine
// 9. Callbacks
// 10. Init
// ------------------------------------------------------------
//
// Credits to D. Healey, HISEnberg, beyhanklic, J. Moon, S. Kurtz, S. Kolasa
// for tools, information, and advice. I am just making it up as I go along. 
// These are the real legends.
//

// ------------------------------------------------------------
// 1. CONSTANTS & GLOBAL STATE
// ------------------------------------------------------------
Content.makeFrontInterface(700, 800);

const NUM_STEPS = 16;

// Per-step pitch (semitones)
reg step1Pitch = 0;
reg step2Pitch = 0;
reg step3Pitch = 0;
reg step4Pitch = 0;
reg step5Pitch = 0;
reg step6Pitch = 0;
reg step7Pitch = 0;
reg step8Pitch = 0;
reg step9Pitch = 0;
reg step10Pitch = 0;
reg step11Pitch = 0;
reg step12Pitch = 0;

// Last 4 as plain var
var step13Pitch = 0;
var step14Pitch = 0;
var step15Pitch = 0;
var step16Pitch = 0;

// Per-step gate (1 = on, 0 = off)
reg step1Gate = 1;
reg step2Gate = 1;
reg step3Gate = 1;
reg step4Gate = 1;
reg step5Gate = 1;
reg step6Gate = 1;
reg step7Gate = 1;
reg step8Gate = 1; 
reg step9Gate = 1;
reg step10Gate = 1;
reg step11Gate = 1;
reg step12Gate = 1;

// Last 4 as plain var
var step13Gate = 1;
var step14Gate = 1;
var step15Gate = 1;
var step16Gate = 1;

// Per-step velocity (1–127), default = 100
var step1Velocity = 100;
var step2Velocity = 100;
var step3Velocity = 100;
var step4Velocity = 100;
var step5Velocity = 100;
var step6Velocity = 100;
var step7Velocity = 100;
var step8Velocity = 100;
var step9Velocity = 100;
var step10Velocity = 100;
var step11Velocity = 100;
var step12Velocity = 100;
var step13Velocity = 100;
var step14Velocity = 100;
var step15Velocity = 100;
var step16Velocity = 100;

// Global sequencer state
reg tempoBPM = 120;
reg stepIndex = 0;
reg isRunning = false;
reg activeSteps = 16; // how many steps are in the loop
reg directionMode = 0; // 0 = forward, 1 = backward, 2 = mirror, 3 = random
reg randSeed = 12345;

reg rootNote = 60;  // default C4
reg scaleMode = 0;   // 0 = none, 1 = chromatic, 2..8 modes
var octaveRange = 2;  // 1..5 => 1..5 octaves up/down

var lastNote = -1;
var lastChannel = 1;

// Tempo / division / sync
var divisionFactor = 4; // default: 1/16 notes (1/4=1, 1/8=2, 1/16=4, 1/32=8)
var useHostTempo = 0; // 0 = tempo knob, 1 = host tempo (future)

// Randomization amount (0..100)
var randomAmount = 100;

// LED / timer
var lastLedIndex = -1; // which step was lit last (-1 = none)
const var seqTimer = Engine.createTimerObject();

// BPM / Start button
const var BpmLabel = Content.getComponent("BpmLabel");
const var StartButtonComponent = Content.getComponent("StartButton");

// Direction buttons 
const var DirForwardButton = Content.getComponent("DirForward");
const var DirBackwardButton = Content.getComponent("DirBackward");
const var DirPingPongButton = Content.getComponent("DirPingPong");
const var DirRandomButton = Content.getComponent("DirRandom");

// Step LEDs (global so seqTimerCallback can reach them)
const var StepLED1 = Content.getComponent("StepLED1");
const var StepLED2 = Content.getComponent("StepLED2");
const var StepLED3 = Content.getComponent("StepLED3");
const var StepLED4 = Content.getComponent("StepLED4");
const var StepLED5 = Content.getComponent("StepLED5");
const var StepLED6 = Content.getComponent("StepLED6");
const var StepLED7 = Content.getComponent("StepLED7");
const var StepLED8 = Content.getComponent("StepLED8");
const var StepLED9 = Content.getComponent("StepLED9");
const var StepLED10 = Content.getComponent("StepLED10");
const var StepLED11 = Content.getComponent("StepLED11");
const var StepLED12 = Content.getComponent("StepLED12");
const var StepLED13 = Content.getComponent("StepLED13");
const var StepLED14 = Content.getComponent("StepLED14");
const var StepLED15 = Content.getComponent("StepLED15");
const var StepLED16 = Content.getComponent("StepLED16");

// Velocity page LEDs (17–32)
const var StepLED17 = Content.getComponent("StepLED17");
const var StepLED18 = Content.getComponent("StepLED18");
const var StepLED19 = Content.getComponent("StepLED19");
const var StepLED20 = Content.getComponent("StepLED20");
const var StepLED21 = Content.getComponent("StepLED21");
const var StepLED22 = Content.getComponent("StepLED22");
const var StepLED23 = Content.getComponent("StepLED23");
const var StepLED24 = Content.getComponent("StepLED24");
const var StepLED25 = Content.getComponent("StepLED25");
const var StepLED26 = Content.getComponent("StepLED26");
const var StepLED27 = Content.getComponent("StepLED27");
const var StepLED28 = Content.getComponent("StepLED28");
const var StepLED29 = Content.getComponent("StepLED29");
const var StepLED30 = Content.getComponent("StepLED30");
const var StepLED31 = Content.getComponent("StepLED31");
const var StepLED32 = Content.getComponent("StepLED32");

// Custom 1 LEDs (33-48)
const var StepLED33 = Content.getComponent("StepLED33");
const var StepLED34 = Content.getComponent("StepLED34");
const var StepLED35 = Content.getComponent("StepLED35");
const var StepLED36 = Content.getComponent("StepLED36");
const var StepLED37 = Content.getComponent("StepLED37");
const var StepLED38 = Content.getComponent("StepLED38");
const var StepLED39 = Content.getComponent("StepLED39");
const var StepLED40 = Content.getComponent("StepLED40");
const var StepLED41 = Content.getComponent("StepLED41");
const var StepLED42 = Content.getComponent("StepLED42");
const var StepLED43 = Content.getComponent("StepLED43");
const var StepLED44 = Content.getComponent("StepLED44");
const var StepLED45 = Content.getComponent("StepLED45");
const var StepLED46 = Content.getComponent("StepLED46");
const var StepLED47 = Content.getComponent("StepLED47");
const var StepLED48 = Content.getComponent("StepLED48");

// Custom 2 (49-64)
const var StepLED49 = Content.getComponent("StepLED49");
const var StepLED50 = Content.getComponent("StepLED50");
const var StepLED51 = Content.getComponent("StepLED51");
const var StepLED52 = Content.getComponent("StepLED52");
const var StepLED53 = Content.getComponent("StepLED53");
const var StepLED54 = Content.getComponent("StepLED54");
const var StepLED55 = Content.getComponent("StepLED55");
const var StepLED56 = Content.getComponent("StepLED56");
const var StepLED57 = Content.getComponent("StepLED57");
const var StepLED58 = Content.getComponent("StepLED58");
const var StepLED59 = Content.getComponent("StepLED59");
const var StepLED60 = Content.getComponent("StepLED60");
const var StepLED61 = Content.getComponent("StepLED61");
const var StepLED62 = Content.getComponent("StepLED62");
const var StepLED63 = Content.getComponent("StepLED63");
const var StepLED64 = Content.getComponent("StepLED64");

// Custom 3 LEDs (81-96)
const var StepLED81 = Content.getComponent("StepLED81");
const var StepLED82 = Content.getComponent("StepLED82");
const var StepLED83 = Content.getComponent("StepLED83");
const var StepLED84 = Content.getComponent("StepLED84");
const var StepLED85 = Content.getComponent("StepLED85");
const var StepLED86 = Content.getComponent("StepLED86");
const var StepLED87 = Content.getComponent("StepLED87");
const var StepLED88 = Content.getComponent("StepLED88");
const var StepLED89 = Content.getComponent("StepLED89");
const var StepLED90 = Content.getComponent("StepLED90");
const var StepLED91 = Content.getComponent("StepLED91");
const var StepLED92 = Content.getComponent("StepLED92");
const var StepLED93 = Content.getComponent("StepLED93");
const var StepLED94 = Content.getComponent("StepLED94");
const var StepLED95 = Content.getComponent("StepLED95");
const var StepLED96 = Content.getComponent("StepLED96");

// Direction buttons (global styling)
const var DirForwardComp = Content.getComponent("DirForward");
const var DirBackwardComp = Content.getComponent("DirBackward");
const var DirPingPongComp = Content.getComponent("DirPingPong");
const var DirRandomComp = Content.getComponent("DirRandom");

// --- Custom lane CC targets (Option A) ---
const var CUSTOM1_CC = 20;
const var CUSTOM2_CC = 21;
const var CUSTOM3_CC = 22;

// Per-step Custom values (0..127 expected)
var step1Custom1 = 0; var step2Custom1 = 0; var step3Custom1 = 0; var step4Custom1 = 0;
var step5Custom1 = 0; var step6Custom1 = 0; var step7Custom1 = 0; var step8Custom1 = 0;
var step9Custom1 = 0; var step10Custom1 = 0; var step11Custom1 = 0; var step12Custom1 = 0;
var step13Custom1 = 0; var step14Custom1 = 0; var step15Custom1 = 0; var step16Custom1 = 0;

var step1Custom2 = 0; var step2Custom2 = 0; var step3Custom2 = 0; var step4Custom2 = 0;
var step5Custom2 = 0; var step6Custom2 = 0; var step7Custom2 = 0; var step8Custom2 = 0;
var step9Custom2 = 0; var step10Custom2 = 0; var step11Custom2 = 0; var step12Custom2 = 0;
var step13Custom2 = 0; var step14Custom2 = 0; var step15Custom2 = 0; var step16Custom2 = 0;

var step1Custom3 = 0; var step2Custom3 = 0; var step3Custom3 = 0; var step4Custom3 = 0;
var step5Custom3 = 0; var step6Custom3 = 0; var step7Custom3 = 0; var step8Custom3 = 0;
var step9Custom3 = 0; var step10Custom3 = 0; var step11Custom3 = 0; var step12Custom3 = 0;
var step13Custom3 = 0; var step14Custom3 = 0; var step15Custom3 = 0; var step16Custom3 = 0;

inline function clamp127(v) {
	local out = v;

    if (out < 0) out = 0;
    if (out > 127) out = 127;

    return out;
}

// ------------------------------------------------------------
// LEARN HELPER (CC Learn Assist)
// ------------------------------------------------------------

// Learn UI
const var LearnCustom1Btn = Content.getComponent("LearnCustom1");
const var LearnCustom2Btn = Content.getComponent("LearnCustom2");
const var LearnCustom3Btn = Content.getComponent("LearnCustom3");
const var LearnStatusLabel = Content.getComponent("LearnStatusLabel");

// Learn state
var learnCustom1Armed = false;
var learnCustom2Armed = false;
var learnCustom3Armed = false;

// Learn sender timer (repeats CC bursts so MIDI learn reliably catches it)
const var learnTimer = Engine.createTimerObject();
var learnPulse = 0;  // toggles 0/127


// ------------------------------------------------------------
// 2. LOOK & FEEL (KNOBS + STEP LEDS + PANELS + BUTTONS)
// ------------------------------------------------------------

// 2.1 Knob look and feel

const var knobIds = [
    "TempoKnob",
    "StepsActive",
    "RandAmount",
    "Step1Pitch", "Step2Pitch", "Step3Pitch", "Step4Pitch",
    "Step5Pitch", "Step6Pitch", "Step7Pitch", "Step8Pitch",
    "Step9Pitch", "Step10Pitch", "Step11Pitch", "Step12Pitch",
    "Step13Pitch", "Step14Pitch", "Step15Pitch", "Step16Pitch",
    "Step1Velocity", "Step2Velocity", "Step3Velocity", "Step4Velocity",
    "Step5Velocity", "Step6Velocity", "Step7Velocity", "Step8Velocity",
    "Step9Velocity", "Step10Velocity", "Step11Velocity", "Step12Velocity",
    "Step13Velocity", "Step14Velocity", "Step15Velocity", "Step16Velocity",
    "Step1Custom1", "Step2Custom1", "Step3Custom1", "Step4Custom1",
    "Step5Custom1", "Step6Custom1", "Step7Custom1", "Step8Custom1",
    "Step9Custom1", "Step10Custom1", "Step11Custom1", "Step12Custom1",
    "Step13Custom1", "Step14Custom1", "Step15Custom1", "Step16Custom1",
    "Step1Custom2", "Step2Custom2", "Step3Custom2", "Step4Custom2",
    "Step5Custom2", "Step6Custom2", "Step7Custom2", "Step8Custom2",
    "Step9Custom2", "Step10Custom2", "Step11Custom2", "Step12Custom2",
    "Step13Custom2", "Step14Custom2", "Step15Custom2", "Step16Custom2",
    "Step1Custom3", "Step2Custom3", "Step3Custom3", "Step4Custom3",
    "Step5Custom3", "Step6Custom3", "Step7Custom3", "Step8Custom3",
    "Step9Custom3", "Step10Custom3", "Step11Custom3", "Step12Custom3",
    "Step13Custom3", "Step14Custom3", "Step15Custom3", "Step16Custom3",

];

const var customKnobs = [];
for (i = 0; i < knobIds.length; i++)
    customKnobs[i] = Content.getComponent(knobIds[i]);

const var laf_Knob = Content.createLocalLookAndFeel();

laf_Knob.registerFunction("drawRotarySlider", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var knobHeight = 40;
    var knobArea = [x, y, w, knobHeight];
    var cx = x + w * 0.5;
    var cy = y + knobHeight * 0.5;
    var r = Math.min(w, knobHeight) * 0.5 - 4;

    var angleStart = Math.PI * 0.75;
    var angleEnd = Math.PI * 2.25;
    var angle = angleStart + (angleEnd - angleStart) * obj.valueNormalized;

    // Drop shadow
    g.setColour(0x40000000);
    g.fillEllipse([cx - r + 2, cy - r + 4, r * 2, r * 2]);

    // Knob face gradient
    g.setGradientFill([
        obj.itemColour1, cx, cy - r,
        obj.itemColour1 | 0x00202020, cx, cy + r,
        true
    ]);
    g.fillEllipse([cx - r, cy - r, r * 2, r * 2]);

    // Rim highlight
    g.setColour(0x22FFFFFF);
    g.drawEllipse([cx - r, cy - r, r * 2, r * 2], 1.0);

    // Glossy overlay
    g.setGradientFill([
        0x66FFFFFF, cx, cy - r,
        0x00FFFFFF, cx, cy + r,
        true
    ]);
    g.fillEllipse([cx - r * 0.95, cy - r * 0.95, r * 1.9, r * 1.9]);

    // Indicator line
    var startDistance = r * 0.15;
    var endDistance = r * 0.93;

    var startX = cx + Math.cos(angle) * startDistance;
    var startY = cy + Math.sin(angle) * startDistance;
    var endX = cx + Math.cos(angle) * endDistance;
    var endY = cy + Math.sin(angle) * endDistance;

    var indicatorColour = obj.clicked ? 0xFF0037FF : 0xFFFFFFFF;  // blue / white
    g.setColour(indicatorColour);
    g.drawLine(startX, endX, startY, endY, 2.0);

    // Label text in bottom third
    var textHeight = h / 3;
    var textArea = [x, y + h - textHeight, w, textHeight];
    g.setColour(obj.textColour);

    var displayValue = Math.round(obj.value) + obj.suffix;
    var displayText = obj.clicked ? displayValue : obj.text;
    g.drawAlignedText(displayText, textArea, "centred");
});

// Apply knob LAF
for (i = 0; i < customKnobs.length; i++) {
    if (customKnobs[i] != undefined)
        customKnobs[i].setLocalLookAndFeel(laf_Knob);
}

// 2.2 LED look and feel (Step LEDs as glowing circles)

const var laf_StepLED = Content.createLocalLookAndFeel();

laf_StepLED.registerFunction("drawToggleButton", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var cx = x + w * 0.5;
    var cy = y + h * 0.5;
    var r = Math.min(w, h) * 0.35;

    var isOn = obj.value > 0.5;
    g.fillAll(0x00000000);

    if (isOn) {
        // Outer glow
        g.setGradientFill([
            0x120037FF, cx, cy - r * 1.6,
            0x120037FF, cx, cy + r * 1.6,
            true
        ]);
        g.fillEllipse([cx - r * 1.8, cy - r * 1.8, r * 3.6, r * 3.6]);

        // Core
        g.setGradientFill([
            0x120037FF, cx, cy - r,
            0xFF0037FF, cx, cy + r,
            true
        ]);
        g.fillEllipse([cx - r, cy - r, r * 2, r * 2]);

        // Highlight
        g.setGradientFill([
            0x66FFFFFF, cx, cy - r,
            0x120037FF, cx, cy + r,
            true
        ]);
        g.fillEllipse([cx - r * 0.9, cy - r * 1.0, r * 1.8, r * 1.8]);
    }
    else {
        // Off
        g.setGradientFill([
            0xFF12141A, cx, cy - r,
            0xFF05070A, cx, cy + r,
            true
        ]);
        g.fillEllipse([cx - r, cy - r, r * 2, r * 2]);

        g.setColour(0x33FFFFFF);
        g.drawEllipse([cx - r, cy - r, r * 2, r * 2], 1.0);
    }
});

// Apply LED LAF
StepLED1.setLocalLookAndFeel(laf_StepLED);
StepLED2.setLocalLookAndFeel(laf_StepLED);
StepLED3.setLocalLookAndFeel(laf_StepLED);
StepLED4.setLocalLookAndFeel(laf_StepLED);
StepLED5.setLocalLookAndFeel(laf_StepLED);
StepLED6.setLocalLookAndFeel(laf_StepLED);
StepLED7.setLocalLookAndFeel(laf_StepLED);
StepLED8.setLocalLookAndFeel(laf_StepLED);
StepLED9.setLocalLookAndFeel(laf_StepLED);
StepLED10.setLocalLookAndFeel(laf_StepLED);
StepLED11.setLocalLookAndFeel(laf_StepLED);
StepLED12.setLocalLookAndFeel(laf_StepLED);
StepLED13.setLocalLookAndFeel(laf_StepLED);
StepLED14.setLocalLookAndFeel(laf_StepLED);
StepLED15.setLocalLookAndFeel(laf_StepLED);
StepLED16.setLocalLookAndFeel(laf_StepLED);

// Velocity page LEDs
StepLED17.setLocalLookAndFeel(laf_StepLED);
StepLED18.setLocalLookAndFeel(laf_StepLED);
StepLED19.setLocalLookAndFeel(laf_StepLED);
StepLED20.setLocalLookAndFeel(laf_StepLED);
StepLED21.setLocalLookAndFeel(laf_StepLED);
StepLED22.setLocalLookAndFeel(laf_StepLED);
StepLED23.setLocalLookAndFeel(laf_StepLED);
StepLED24.setLocalLookAndFeel(laf_StepLED);
StepLED25.setLocalLookAndFeel(laf_StepLED);
StepLED26.setLocalLookAndFeel(laf_StepLED);
StepLED27.setLocalLookAndFeel(laf_StepLED);
StepLED28.setLocalLookAndFeel(laf_StepLED);
StepLED29.setLocalLookAndFeel(laf_StepLED);
StepLED30.setLocalLookAndFeel(laf_StepLED);
StepLED31.setLocalLookAndFeel(laf_StepLED);
StepLED32.setLocalLookAndFeel(laf_StepLED);

// Custom 1 LEDs
StepLED33.setLocalLookAndFeel(laf_StepLED);
StepLED34.setLocalLookAndFeel(laf_StepLED);
StepLED35.setLocalLookAndFeel(laf_StepLED);
StepLED36.setLocalLookAndFeel(laf_StepLED);
StepLED37.setLocalLookAndFeel(laf_StepLED);
StepLED38.setLocalLookAndFeel(laf_StepLED);
StepLED39.setLocalLookAndFeel(laf_StepLED);
StepLED40.setLocalLookAndFeel(laf_StepLED);
StepLED41.setLocalLookAndFeel(laf_StepLED);
StepLED42.setLocalLookAndFeel(laf_StepLED);
StepLED43.setLocalLookAndFeel(laf_StepLED);
StepLED44.setLocalLookAndFeel(laf_StepLED);
StepLED45.setLocalLookAndFeel(laf_StepLED);
StepLED46.setLocalLookAndFeel(laf_StepLED);
StepLED47.setLocalLookAndFeel(laf_StepLED);
StepLED48.setLocalLookAndFeel(laf_StepLED);

// Custom 2 LEDs
StepLED49.setLocalLookAndFeel(laf_StepLED);
StepLED50.setLocalLookAndFeel(laf_StepLED);
StepLED51.setLocalLookAndFeel(laf_StepLED);
StepLED52.setLocalLookAndFeel(laf_StepLED);
StepLED53.setLocalLookAndFeel(laf_StepLED);
StepLED54.setLocalLookAndFeel(laf_StepLED);
StepLED55.setLocalLookAndFeel(laf_StepLED);
StepLED56.setLocalLookAndFeel(laf_StepLED);
StepLED57.setLocalLookAndFeel(laf_StepLED);
StepLED58.setLocalLookAndFeel(laf_StepLED);
StepLED59.setLocalLookAndFeel(laf_StepLED);
StepLED60.setLocalLookAndFeel(laf_StepLED);
StepLED61.setLocalLookAndFeel(laf_StepLED);
StepLED62.setLocalLookAndFeel(laf_StepLED);
StepLED63.setLocalLookAndFeel(laf_StepLED);
StepLED64.setLocalLookAndFeel(laf_StepLED);

// Custom 3 LEDs (81-96)
StepLED81.setLocalLookAndFeel(laf_StepLED);
StepLED82.setLocalLookAndFeel(laf_StepLED);
StepLED83.setLocalLookAndFeel(laf_StepLED);
StepLED84.setLocalLookAndFeel(laf_StepLED);
StepLED85.setLocalLookAndFeel(laf_StepLED);
StepLED86.setLocalLookAndFeel(laf_StepLED);
StepLED87.setLocalLookAndFeel(laf_StepLED);
StepLED88.setLocalLookAndFeel(laf_StepLED);
StepLED89.setLocalLookAndFeel(laf_StepLED);
StepLED90.setLocalLookAndFeel(laf_StepLED);
StepLED91.setLocalLookAndFeel(laf_StepLED);
StepLED92.setLocalLookAndFeel(laf_StepLED);
StepLED93.setLocalLookAndFeel(laf_StepLED);
StepLED94.setLocalLookAndFeel(laf_StepLED);
StepLED95.setLocalLookAndFeel(laf_StepLED);
StepLED96.setLocalLookAndFeel(laf_StepLED);

// 2.3 START BUTTON LOOK & FEEL (PLAY ▶ → STOP ⏹)

const var laf_StartButton = Content.createLocalLookAndFeel();

laf_StartButton.registerFunction("drawToggleButton", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var cx = x + w * 0.5;
    var cy = y + h * 0.5;
    var r = 6; // corner radius

    var isOn = obj.value > 0.5;  // toggle state

    // Clear
    g.fillAll(0x00000000);

    if (isOn) {
        // === RUNNING: glowing blue square ===

        // Outer glow
        g.setColour(0x550037FF);
        g.fillRoundedRectangle([x - 2, y - 2, w + 4, h + 4], r + 2);

        // Main gradient background
        g.setGradientFill([
            0xFF0037FF, cx, y,
            0xFF001025, cx, y + h,
            true
        ]);
        g.fillRoundedRectangle([x, y, w, h], r);

        // Inner dark panel
        g.setColour(0xFF05080B);
        g.fillRoundedRectangle([x + 2, y + 2, w - 4, h - 4], r - 1);

        // Stop icon (white rounded square)
        var iconSize = Math.min(w, h) * 0.35;
        g.setColour(0xFFFFFFFF);
        g.fillRoundedRectangle(
            [cx - iconSize * 0.5, cy - iconSize * 0.5, iconSize, iconSize],
            3
        );
    }
    else {
        // === STOPPED: dark panel with grey play triangle ===

        // Base panel
        g.setColour(0xFF05080B);
        g.fillRoundedRectangle([x, y, w, h], r);

        // Border
        g.setColour(0xFF303030);
        g.drawRoundedRectangle([x + 0.5, y + 0.5, w - 1, h - 1], r, 1.0);

        // === PLAY ICON: right-pointing triangle ===
        var iconW = Math.min(w, h) * 0.35;
        var iconH = iconW * 0.9;

        // Tip on the RIGHT, base on the LEFT
        var tipX = cx + iconW * 0.4;        // rightmost point
        var tipY = cy;

        var baseX = tipX - iconW;            // left edge of triangle
        var topY = cy - iconH * 0.5;
        var botY = cy + iconH * 0.5;

        // Name them for readability
        var x1 = baseX; var y1 = topY;       // top-left
        var x2 = baseX; var y2 = botY;       // bottom-left
        var x3 = tipX; var y3 = tipY;       // right tip

        g.setColour(0xFFB0B0B0);

        // Line 1: top-left -> tip
        g.drawLine(x1, x3, y1, y3, 2.0);
        // Line 2: tip -> bottom-left
        g.drawLine(x3, x2, y3, y2, 2.0);
        // Line 3: bottom-left -> top-left
        g.drawLine(x2, x1, y2, y1, 2.0);

    }

    // (No text - icon only. updateStartButtonLook still manages logic.)
});

// Apply this LAF to the Start button
StartButtonComponent.setLocalLookAndFeel(laf_StartButton);

//2.4 Tabbed Panels

//Grab control references
const var NUM_TABS = 5; // This number is for the number of panels and affects what i+1 formula below
const var panels = [];
const var buttons = [];

for (i = 0; i < NUM_TABS; i++) {
    panels[i] = Content.getComponent("Panel" + (i + 1));
    buttons[i] = Content.getComponent("Button" + (i + 1));

    buttons[i].setControlCallback(changeTab);
}

//Tab button callback function
inline function changeTab(component, value) {
    if (value) {
		local idx = buttons.indexOf(component);

        //Hide all panels
        for (i = 0; i < panels.length; i++) {
            panels[i].set("visible", false);
        }

        //Show selected panel
        panels[idx].set("visible", true);
    }
}

//2.5 Direction buttons
const var laf_Direction = Content.createLocalLookAndFeel();

// ---------- icon drawing helpers (TOP LEVEL, no nesting) ----------

inline function drawTriangleRight(g, cx, cy, s, col, thick) {
    g.setColour(col);
    // triangle points
    local x1 = cx - s * 0.55;
    local y1 = cy - s * 0.75;

    local x2 = cx - s * 0.55;
    local y2 = cy + s * 0.75;

    local x3 = cx + s * 0.75;
    local y3 = cy;

    // outline triangle
    g.drawLine(x1, x2, y1, y2, thick);
    g.drawLine(x2, x3, y2, y3, thick);
    g.drawLine(x3, x1, y3, y1, thick);

}

inline function drawTriangleLeft(g, cx, cy, s, col, thick) {
    g.setColour(col);

    local x1 = cx + s * 0.55;
    local y1 = cy - s * 0.75;

    local x2 = cx + s * 0.55;
    local y2 = cy + s * 0.75;

    local x3 = cx - s * 0.75;
    local y3 = cy;

    g.drawLine(x1, x2, y1, y2, thick);
    g.drawLine(x2, x3, y2, y3, thick);
    g.drawLine(x3, x1, y3, y1, thick);

}

inline function drawPingPong(g, cx, cy, s, col, thick) {
    // looks like: -><-
    // right triangle on left half, left triangle on right half
    drawTriangleRight(g, cx - s * 0.45, cy, s * 0.85, col, thick);
    drawTriangleLeft(g, cx + s * 0.45, cy, s * 0.85, col, thick);
}

inline function drawDice(g, cx, cy, s, col, isOn) {
    // Dice size
    local boxSize = s * 1.4;
    local rBox = 4.0;

    // Background box
    if (isOn) {
        // Glow
        g.setColour(0x300037FF);
        g.fillRoundedRectangle(
            [cx - boxSize * 0.5 - 2, cy - boxSize * 0.5 - 2,
            boxSize + 4, boxSize + 4],
            rBox + 2
        );

        // Active box
        g.setColour(0xFF05080B);
        g.fillRoundedRectangle(
            [cx - boxSize * 0.5, cy - boxSize * 0.5,
                boxSize, boxSize],
            rBox
        );

        g.setColour(0xFF0037FF);
        g.drawRoundedRectangle(
            [cx - boxSize * 0.5, cy - boxSize * 0.5,
                boxSize, boxSize],
            rBox, 1.5
        );
    }
    else {
        // Inactive box
        g.setColour(0xFF05080B);
        g.fillRoundedRectangle(
            [cx - boxSize * 0.5, cy - boxSize * 0.5,
                boxSize, boxSize],
            rBox
        );

        g.setColour(0xFF303030);
        g.drawRoundedRectangle(
            [cx - boxSize * 0.5, cy - boxSize * 0.5,
                boxSize, boxSize],
            rBox, 1.0
        );
    }

    // ---- Dice dots ----
    g.setColour(col);

    local r = s * 0.16;   // dot radius
    local d = s * 0.38;   // dot spacing

    // Top-left
    g.fillEllipse([cx - d - r, cy - d - r, r * 2, r * 2]);
    // Top-right
    g.fillEllipse([cx + d - r, cy - d - r, r * 2, r * 2]);
    // Center
    g.fillEllipse([cx - r, cy - r, r * 2, r * 2]);
    // Bottom-left
    g.fillEllipse([cx - d - r, cy + d - r, r * 2, r * 2]);
    // Bottom-right
    g.fillEllipse([cx + d - r, cy + d - r, r * 2, r * 2]);
}

// ---------- shared “play button” frame + icon draw ----------

laf_Direction.registerFunction("drawToggleButton", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var cx = x + w * 0.5;
    var cy = y + h * 0.5;

    var isOn = obj.value > 0.5;

    // colours (match your Start button vibe)
    var frameOn = 0xFF0037FF;
    var frameOff = 0xFF303030;
    var fill = 0xFF05080B;

    // clear
    g.fillAll(0x00000000);

    // frame + fill
    g.setColour(isOn ? frameOn : frameOff);
    g.drawRoundedRectangle([x + 1, y + 1, w - 2, h - 2], 6.0, 2.0);

    g.setColour(fill);
    g.fillRoundedRectangle([x + 3, y + 3, w - 6, h - 6], 5.0);

    // glow when active (subtle)
    if (isOn) {
        g.setGradientFill([
            0x300037FF, cx, cy - h,
            0x000037FF, cx, cy + h,
            true
        ]);
        g.fillRoundedRectangle([x - 2, y - 2, w + 4, h + 4], 8.0);
    }

    // icon colour
    var iconCol = isOn ? 0xFFFFFFFF : 0xFFB0B0B0;
    var thick = 2.4;
    var s = Math.min(w, h) * 0.22;

    // Choose which icon to draw based on component ID
    // (This avoids unicode completely)
    if (obj.id == "DirForward")
        drawTriangleRight(g, cx, cy, s * 2.0, iconCol, thick);
    else if (obj.id == "DirBackward")
        drawTriangleLeft(g, cx, cy, s * 2.0, iconCol, thick);
    else if (obj.id == "DirPingPong")
        drawPingPong(g, cx, cy, s * 1.6, iconCol, thick);
    else if (obj.id == "DirRandom")
        drawDice(g, cx, cy, s * 2.2, iconCol, isOn);
});

DirForwardComp.setLocalLookAndFeel(laf_Direction);
DirBackwardComp.setLocalLookAndFeel(laf_Direction);
DirPingPongComp.setLocalLookAndFeel(laf_Direction);
DirRandomComp.setLocalLookAndFeel(laf_Direction);

// 2.6 Organize buttons
const var laf_Combo = Content.createLocalLookAndFeel();

// Main closed combo box
laf_Combo.registerFunction("drawComboBox", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var cx = x + w * 0.5;
    var cy = y + h * 0.5;

    var r = 6.0;

    // Colours (match your direction/random button frames)
    var frameOn = 0xFF0037FF;   // neon blue
    var frameOff = 0xFF303030;   // dark grey
    var fill = 0xFF05080B;   // dark

    // In HISE LAF, obj.hover and obj.clicked are often available.
    var isHot = (obj.hover || obj.clicked);

    // Clear
    g.fillAll(0x00000000);

    // Subtle glow on hover/click
    if (isHot) {
        g.setGradientFill([
            0x250037FF, cx, cy - h,
            0x000037FF, cx, cy + h,
            true
        ]);
        g.fillRoundedRectangle([x - 2, y - 2, w + 4, h + 4], r + 2);
    }

    // Frame
    g.setColour(isHot ? frameOn : frameOff);
    g.drawRoundedRectangle([x + 1, y + 1, w - 2, h - 2], r, 2.0);

    // Inner fill
    g.setColour(fill);
    g.fillRoundedRectangle([x + 3, y + 3, w - 6, h - 6], r - 1);

    // Text (use displayed text from the combobox)
    g.setColour(0xFFB0B0B0);

    // Leave space at right for arrow
    var textArea = [x + 8, y + 2, w - 26, h - 4];
    g.drawAlignedText(obj.text, textArea, "left");

    // Dropdown arrow (simple V shape) on the right
    var ax = x + w - 14;
    var ay = cy;

    g.setColour(isHot ? 0xFFFFFFFF : 0xFFB0B0B0);

    // V shape: remember drawLine(x1, y1, x2, y2, thickness)
    g.drawLine(ax - 5, ax, ay - 2, ay + 3, 2.0);
    g.drawLine(ax, ax + 5, ay + 3, ay - 2, 2.0);
});

// Dropdown menu items (when the combo is opened)
laf_Combo.registerFunction("drawPopupMenuItem", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    // obj.isHighlighted is commonly provided for menu items
    var hi = obj.isHighlighted;

    // Background
    if (hi)
        g.fillAll(0xFF001025);     // slightly blue-tinted dark
    else
        g.fillAll(0xFF05080B);     // dark

    g.setColour(hi ? 0xFFFFFFFF : 0xFFB0B0B0);
    g.drawAlignedText(obj.text, [x + 10, y, w - 20, h], "left");

});

// Apply LAF to combo boxes
Content.getComponent("KeySelector").setLocalLookAndFeel(laf_Combo);
Content.getComponent("ScaleMode").setLocalLookAndFeel(laf_Combo);
Content.getComponent("OctaveRange").setLocalLookAndFeel(laf_Combo);
Content.getComponent("DivisionSelector").setLocalLookAndFeel(laf_Combo);

// Sync button
const var SyncButton = Content.getComponent("SyncToggle");
const var laf_Sync = Content.createLocalLookAndFeel();

laf_Sync.registerFunction("drawToggleButton", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var cx = x + w * 0.5;
    var cy = y + h * 0.5;

    var isOn = obj.value > 0.5;
    var isHot = (obj.hover || obj.clicked);

    var r = 6.0;

    var frameOn = 0xFF0037FF;
    var frameOff = 0xFF303030;
    var fill = 0xFF05080B;

    // Clear
    g.fillAll(0x00000000);

    // Glow when ON (and a little on hover)
    if (isOn || isHot) {
        g.setGradientFill([
            0x250037FF, cx, cy - h,
            0x000037FF, cx, cy + h,
            true
        ]);
        g.fillRoundedRectangle([x - 2, y - 2, w + 4, h + 4], r + 2);
    }

    // Frame
    g.setColour(isOn ? frameOn : frameOff);
    g.drawRoundedRectangle([x + 1, y + 1, w - 2, h - 2], r, 2.0);

    // Fill
    g.setColour(fill);
    g.fillRoundedRectangle([x + 3, y + 3, w - 6, h - 6], r - 1);

    // Text
    g.setColour(isOn ? 0xFFFFFFFF : 0xFFB0B0B0);

    // Use the component's text (whatever you set in the UI)
    // or hardcode if you prefer.
    g.drawAlignedText(obj.text, [x, y, w, h], "centred");
});

// Apply
SyncButton.setLocalLookAndFeel(laf_Sync);

// 2.7 Tabs for the panels
const var Tab1 = Content.getComponent("Button1");
const var Tab2 = Content.getComponent("Button2");
const var Tab3 = Content.getComponent("Button3");
const var Tab4 = Content.getComponent("Button4");
const var Tab5 = Content.getComponent("Button5");

const var tabButtons = [Tab1, Tab2, Tab3, Tab4, Tab5];

const var laf_Tabs = Content.createLocalLookAndFeel();

laf_Tabs.registerFunction("drawToggleButton", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var isOn = obj.value > 0.5;
    var isHot = (obj.hover || obj.clicked);

    var r = 9.0;                 // corner radius
    var inset = isOn ? 0.0 : 5.0; // inactive tabs sit back a bit

    var frameOn = 0xFF0037FF;
    var frameOff = 0xFF303030;
    var fill = 0xFF05080B;

    // Clear
    g.fillAll(0x00000000);

    // Optional glow for active / hover
    if (isOn || isHot) {
        g.setColour(isOn ? 0x220037FF : 0x140037FF);
        g.fillRoundedRectangle([x - 2, y - 1, w + 4, h + 2], r + 2);
    }

    // --- Build a "binder tab" shape:
    // Main body: rounded rectangle
    // Plus a left "lip": a narrower rounded rectangle that sticks out
    var bodyX = x + inset;
    var bodyY = y + inset;
    var bodyW = w - inset * 2;
    var bodyH = h - inset * 2;

    // Draw fill first
    g.setColour(fill);
    g.fillRoundedRectangle([bodyX, bodyY, bodyW, bodyH], r);

    // Left lip overlay (makes it feel like a tab)
    // (This gives the impression of a tab sticking out of a binder page)
    g.setColour(fill);
    g.fillRoundedRectangle([bodyX - lip, bodyY + 3, lip + 6, bodyH - 6], r);

    // Border frame (active brighter)
    g.setColour(isOn ? frameOn : frameOff);
    g.drawRoundedRectangle([bodyX + 0.5, bodyY + 0.5, bodyW - 1, bodyH - 1], r, 2.0);

    // Text
    g.setColour(isOn ? 0xFFFFFFFF : 0xFFB0B0B0);
    g.drawAlignedText(obj.text, [bodyX + 6, bodyY, bodyW - 10, bodyH], "centred");
});

// Apply to all 5
for (i = 0; i < tabButtons.length; i++) {
    if (tabButtons[i] != undefined)
        tabButtons[i].setLocalLookAndFeel(laf_Tabs);
}

// 2.7 Gate buttons
const var laf_GatePad = Content.createLocalLookAndFeel();

laf_GatePad.registerFunction("drawToggleButton", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var cx = x + w * 0.5;
    var cy = y + h * 0.5;

    var isOn = obj.value > 0.5;
    var isHot = (obj.hover || obj.clicked);

    var r = 6.0; // corner radius

    // palette (matches your UI)
    var fillDark = 0xFF05080B;
    var borderOff = 0xFF303030;
    var borderOn = 0xFF0037FF;
    var glowOn = 0x350037FF;

    g.fillAll(0x00000000);

    // subtle shadow for depth
    g.setColour(0x26000000);
    g.fillRoundedRectangle([x + 2, y + 3, w - 2, h - 2], r);

    // glow when on (and a tiny hint on hover)
    if (isOn) {
        g.setColour(glowOn);
        g.fillRoundedRectangle([x - 3, y - 3, w + 6, h + 6], r + 3);
    }
    else if (isHot) {
        g.setColour(0x120037FF);
        g.fillRoundedRectangle([x - 2, y - 2, w + 4, h + 4], r + 2);
    }

    // main pad
    g.setColour(fillDark);
    g.fillRoundedRectangle([x, y, w, h], r);

    // border
    g.setColour(isOn ? borderOn : borderOff);
    g.drawRoundedRectangle([x + 0.5, y + 0.5, w - 1, h - 1], r, 2.0);

    // inner “lit” plate when on
    if (isOn) {
        g.setGradientFill([
            0x280037FF, cx, y,
            0x000037FF, cx, y + h,
            true
        ]);
        g.fillRoundedRectangle([x + 2, y + 2, w - 4, h - 4], r - 1);
    }
});

// Apply to Step1Gate..Step16Gate
Content.getComponent("Step1Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step2Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step3Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step4Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step5Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step6Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step7Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step8Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step9Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step10Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step11Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step12Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step13Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step14Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step15Gate").setLocalLookAndFeel(laf_GatePad);
Content.getComponent("Step16Gate").setLocalLookAndFeel(laf_GatePad);

// 2.8 Randomize buttons
const var laf_RandButtons = Content.createLocalLookAndFeel();

laf_RandButtons.registerFunction("drawToggleButton", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var cx = x + w * 0.5;
    var cy = y + h * 0.5;

    var isOn = obj.value > 0.5;

    // Match your UI palette
    var frameOn = 0xFF0037FF;  // neon blue
    var frameOff = 0xFF303030;  // dark grey
    var fill = 0xFF05080B;  // dark panel

    // Clear
    g.fillAll(0x00000000);

    // Glow when pressed/on
    if (isOn) {
        g.setGradientFill([
            0x300037FF, cx, cy - h,
            0x000037FF, cx, cy + h,
            true
        ]);
        g.fillRoundedRectangle([x - 2, y - 2, w + 4, h + 4], 8.0);
    }

    // Frame
    g.setColour(isOn ? frameOn : frameOff);
    g.drawRoundedRectangle([x + 1, y + 1, w - 2, h - 2], 6.0, 2.0);

    // Inner fill
    g.setColour(fill);
    g.fillRoundedRectangle([x + 3, y + 3, w - 6, h - 6], 5.0);

    // Text
    g.setColour(isOn ? 0xFFFFFFFF : 0xFFB0B0B0);

    // Use the button's own text (set in HISE UI)
    // Slightly inset text area for better centering
    var textArea = [x + 4, y + 2, w - 8, h - 4];
    g.drawAlignedText(obj.text, textArea, "centred");
});

// Apply to the three random buttons
Content.getComponent("RandPitch").setLocalLookAndFeel(laf_RandButtons);
Content.getComponent("RandGate").setLocalLookAndFeel(laf_RandButtons);
Content.getComponent("RandBoth").setLocalLookAndFeel(laf_RandButtons);

// 2.9 Learn buttons
const var laf_LearnButtons = Content.createLocalLookAndFeel();

laf_LearnButtons.registerFunction("drawToggleButton", function (g, obj) {
    var a = obj.area;
    var x = a[0];
    var y = a[1];
    var w = a[2];
    var h = a[3];

    var cx = x + w * 0.5;
    var cy = y + h * 0.5;

    var isOn = obj.value > 0.5;

    // Match your UI palette (same as laf_RandButtons)
    var frameOn = 0xFF0037FF;  // neon blue
    var frameOff = 0xFF303030;  // dark grey
    var fill = 0xFF05080B;  // dark panel

    // Clear
    g.fillAll(0x00000000);

    // Glow when armed/on
    if (isOn) {
        g.setGradientFill([
            0x300037FF, cx, cy - h,
            0x000037FF, cx, cy + h,
            true
        ]);
        g.fillRoundedRectangle([x - 2, y - 2, w + 4, h + 4], 8.0);
    }

    // Frame
    g.setColour(isOn ? frameOn : frameOff);
    g.drawRoundedRectangle([x + 1, y + 1, w - 2, h - 2], 6.0, 2.0);

    // Inner fill
    g.setColour(fill);
    g.fillRoundedRectangle([x + 3, y + 3, w - 6, h - 6], 5.0);

    // Text
    g.setColour(isOn ? 0xFFFFFFFF : 0xFFB0B0B0);

    // Always say LEARN
    var textArea = [x + 4, y + 2, w - 8, h - 4];
    g.drawAlignedText("Learn", textArea, "centred");
});

// Apply to the three Learn buttons
LearnCustom1Btn.setLocalLookAndFeel(laf_LearnButtons);
LearnCustom2Btn.setLocalLookAndFeel(laf_LearnButtons);
LearnCustom3Btn.setLocalLookAndFeel(laf_LearnButtons);



// Dang. You are really reading this thing. 

// ------------------------------------------------------------
// 3. TEMPO HELPERS
// ------------------------------------------------------------

inline function getEffectiveBpm() {
    local bpm = tempoBPM; // later we can add host tempo if useHostTempo == 1
    if (bpm <= 0) bpm = 1;
    return bpm;
}

inline function updateBpmLabel() {
    // Manual rounding for old HISE
    local p = tempoBPM;
    if (p < 0) p = 0;

    local ip = 0;
    while (ip + 1 <= p)
        ip = ip + 1;

    if (p - ip >= 0.5)
        ip = ip + 1;

    BpmLabel.set("text", "" + ip);
}

inline function anyLearnArmed() {
    return learnCustom1Armed || learnCustom2Armed || learnCustom3Armed;
}

inline function updateLearnLabel() {
    if (!anyLearnArmed()) {
        LearnStatusLabel.set("text", "");
        return;
    }

    // Simple clear instruction
    LearnStatusLabel.set("text",
        "MIDI LEARN ARMED: Enable MIDI Learn on your instrument, then press PLAY above. You can unclick this button when you are done.\n" +
        "This plugin is sending CC " +
        (learnCustom1Armed ? "20. " : "") +
        (learnCustom2Armed ? "21. " : "") +
        (learnCustom3Armed ? "22. " : "")
    );
}

// Custom pages

inline function sendLearnBurst() {
    // Alternate between 0 and 127 so even “needs movement” learns work
    local v = (learnPulse == 0) ? 0 : 127;
    learnPulse = 1 - learnPulse;


    if (learnCustom1Armed) Synth.addController(ch, CUSTOM1_CC, v, 0);
    if (learnCustom2Armed) Synth.addController(ch, CUSTOM2_CC, v, 0);
    if (learnCustom3Armed) Synth.addController(ch, CUSTOM3_CC, v, 0);
}

inline function learnTimerCallback(t) {
    if (!anyLearnArmed()) {
        t.stopTimer();
        return;
    }

    sendLearnBurst();
}

// Attach timer callback once
learnTimer.setTimerCallback(learnTimerCallback);


// ------------------------------------------------------------
// 4. RANDOM HELPERS & RANDOMIZATION FUNCTIONS
// ------------------------------------------------------------

// Simple PRNG for randomization (no bitwise)
inline function nextRandomNoStep() {
    randSeed = randSeed * 1664525 + 1013904223;

    while (randSeed < 0)
        randSeed = randSeed + 2147483647;
    while (randSeed > 2147483647)
        randSeed = randSeed - 2147483647;

    return randSeed;
}

// Max semitone span for randomization based on octaveRange
inline function getMaxPitchSpan() {
    local r = octaveRange;
    if (r < 1) r = 1;
    else if (r > 5) r = 5;

    return r * 12; // each octave = 12 semitones
}

// Randomize a single step's pitch around 0..±range
inline function randomizeSinglePitch(stepId, range, span, maxRange) {
    local r = nextRandomNoStep();
    local offset = (r % span) - range;  // -range..+range

    // non-accumulating: offset is the new pitch
    local newPitch = offset;

    // clamp to allowed span
    if (newPitch > maxRange)
        newPitch = maxRange;
    else if (newPitch < -maxRange)
        newPitch = -maxRange;

    Content.getComponent(stepId).setValue(newPitch);
    return newPitch;
}

inline function randomizePitchAll() {
    local amt = randomAmount;
    if (amt < 0) amt = 0;
    else if (amt > 100) amt = 100;

    if (amt <= 0)
        return;

    local maxRange = getMaxPitchSpan();              // e.g. range=3 -> 36
    local range = (maxRange * amt) / 100;         // scale by 0..100%

    if (range < 1)
        range = 1;

    local span = range * 2 + 1;                      // count of int values in [-range..+range]

    step1Pitch = randomizeSinglePitch("Step1Pitch", range, span, maxRange);
    step2Pitch = randomizeSinglePitch("Step2Pitch", range, span, maxRange);
    step3Pitch = randomizeSinglePitch("Step3Pitch", range, span, maxRange);
    step4Pitch = randomizeSinglePitch("Step4Pitch", range, span, maxRange);
    step5Pitch = randomizeSinglePitch("Step5Pitch", range, span, maxRange);
    step6Pitch = randomizeSinglePitch("Step6Pitch", range, span, maxRange);
    step7Pitch = randomizeSinglePitch("Step7Pitch", range, span, maxRange);
    step8Pitch = randomizeSinglePitch("Step8Pitch", range, span, maxRange);
    step9Pitch = randomizeSinglePitch("Step9Pitch", range, span, maxRange);
    step10Pitch = randomizeSinglePitch("Step10Pitch", range, span, maxRange);
    step11Pitch = randomizeSinglePitch("Step11Pitch", range, span, maxRange);
    step12Pitch = randomizeSinglePitch("Step12Pitch", range, span, maxRange);
    step13Pitch = randomizeSinglePitch("Step13Pitch", range, span, maxRange);
    step14Pitch = randomizeSinglePitch("Step14Pitch", range, span, maxRange);
    step15Pitch = randomizeSinglePitch("Step15Pitch", range, span, maxRange);
    step16Pitch = randomizeSinglePitch("Step16Pitch", range, span, maxRange);
}

// Gate randomization: amount = probability each step changes to a new gate
inline function randomizeGateAll() {
    local amt = randomAmount;
    if (amt < 0) amt = 0;
    else if (amt > 100) amt = 100;

    if (amt <= 0)
        return;

    local threshold = amt; // 0..100
    local r;
    local comp;
    local currentValue;
    local candidate;

    // STEP 1
    comp = Content.getComponent("Step1Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 2
    comp = Content.getComponent("Step2Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 3
    comp = Content.getComponent("Step3Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 4
    comp = Content.getComponent("Step4Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 5
    comp = Content.getComponent("Step5Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 6
    comp = Content.getComponent("Step6Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 7
    comp = Content.getComponent("Step7Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 8
    comp = Content.getComponent("Step8Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 9
    comp = Content.getComponent("Step9Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 10
    comp = Content.getComponent("Step10Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 11
    comp = Content.getComponent("Step11Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 12
    comp = Content.getComponent("Step12Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 13
    comp = Content.getComponent("Step13Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 14
    comp = Content.getComponent("Step14Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 15
    comp = Content.getComponent("Step15Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    // STEP 16
    comp = Content.getComponent("Step16Gate");
    currentValue = comp.getValue();
    r = nextRandomNoStep();
    candidate = r % 2;
    r = nextRandomNoStep();
    if ((r % 100) < threshold)
        comp.setValue(candidate);
    else
        comp.setValue(currentValue);
    comp.changed();

    ensureAtLeastOneGateOn(16);


}

inline function ensureAtLeastOneGateOn(maxSteps) {
    local onCount = 0;
    local i;
    local comp;

    // Count ON gates
    for (i = 1; i <= maxSteps; i++) {
        comp = Content.getComponent("Step" + i + "Gate");
        if (comp.getValue() > 0.5)
            onCount++;
    }

    // If all OFF, force one ON (pick a random step)
    if (onCount == 0) {
        local r = nextRandomNoStep();
        local pick = (r % maxSteps) + 1;

        comp = Content.getComponent("Step" + pick + "Gate");
        comp.setValue(1);
        comp.changed();

        // Also keep your script-side gate variables in sync (optional but recommended)
        if (pick == 1) step1Gate = 1;
        else if (pick == 2) step2Gate = 1;
        else if (pick == 3) step3Gate = 1;
        else if (pick == 4) step4Gate = 1;
        else if (pick == 5) step5Gate = 1;
        else if (pick == 6) step6Gate = 1;
        else if (pick == 7) step7Gate = 1;
        else if (pick == 8) step8Gate = 1;
        else if (pick == 9) step9Gate = 1;
        else if (pick == 10) step10Gate = 1;
        else if (pick == 11) step11Gate = 1;
        else if (pick == 12) step12Gate = 1;
        else if (pick == 13) step13Gate = 1;
        else if (pick == 14) step14Gate = 1;
        else if (pick == 15) step15Gate = 1;
        else if (pick == 16) step16Gate = 1;
    }
}


// ------------------------------------------------------------
// 5. QUANTIZATION
// ------------------------------------------------------------

inline function quantizePitchToMode(prePitch) {
    // 0 = None (no quantization at all)
    if (scaleMode == 0)
        return prePitch;

    // 1 = Chromatic (snap to nearest semitone)
    if (scaleMode == 1) {
        local p = prePitch;
        if (p < 0) p = 0;

        local ip = 0;
        while (ip + 1 <= p)
            ip = ip + 1;

        if (p - ip >= 0.5)
            ip = ip + 1;

        return ip;
    }

    // modes 2..8, relative to rootNote
    local rel = prePitch - rootNote;
    local oct = 0;

    while (rel < 0) {
        rel += 12;
        oct -= 1;
    }

    while (rel >= 12) {
        rel -= 12;
        oct += 1;
    }

    local pc = rel;
    local q = pc;

    if (scaleMode == 2) // Major: 0,2,4,5,7,9,11
    {
        if (pc <= 0) q = 0;
        else if (pc <= 2) q = 2;
        else if (pc <= 4) q = 4;
        else if (pc <= 5) q = 5;
        else if (pc <= 7) q = 7;
        else if (pc <= 9) q = 9;
        else q = 11;
    }
    else if (scaleMode == 3) // Natural minor: 0,2,3,5,7,8,10
    {
        if (pc <= 0) q = 0;
        else if (pc <= 2) q = 2;
        else if (pc <= 3) q = 3;
        else if (pc <= 5) q = 5;
        else if (pc <= 7) q = 7;
        else if (pc <= 8) q = 8;
        else q = 10;
    }
    else if (scaleMode == 4) // Dorian: 0,2,3,5,7,9,10
    {
        if (pc <= 0) q = 0;
        else if (pc <= 2) q = 2;
        else if (pc <= 3) q = 3;
        else if (pc <= 5) q = 5;
        else if (pc <= 7) q = 7;
        else if (pc <= 9) q = 9;
        else q = 10;
    }
    else if (scaleMode == 5) // Phrygian: 0,1,3,5,7,8,10
    {
        if (pc <= 0) q = 0;
        else if (pc <= 1) q = 1;
        else if (pc <= 3) q = 3;
        else if (pc <= 5) q = 5;
        else if (pc <= 7) q = 7;
        else if (pc <= 8) q = 8;
        else q = 10;
    }
    else if (scaleMode == 6) // Lydian: 0,2,4,6,7,9,11
    {
        if (pc <= 0) q = 0;
        else if (pc <= 2) q = 2;
        else if (pc <= 4) q = 4;
        else if (pc <= 6) q = 6;
        else if (pc <= 7) q = 7;
        else if (pc <= 9) q = 9;
        else q = 11;
    }
    else if (scaleMode == 7) // Mixolydian: 0,2,4,5,7,9,10
    {
        if (pc <= 0) q = 0;
        else if (pc <= 2) q = 2;
        else if (pc <= 4) q = 4;
        else if (pc <= 5) q = 5;
        else if (pc <= 7) q = 7;
        else if (pc <= 9) q = 9;
        else q = 10;
    }
    else if (scaleMode == 8) // Locrian: 0,1,3,5,6,8,10
    {
        if (pc <= 0) q = 0;
        else if (pc <= 1) q = 1;
        else if (pc <= 3) q = 3;
        else if (pc <= 5) q = 5;
        else if (pc <= 6) q = 6;
        else if (pc <= 8) q = 8;
        else q = 10;
    }

    local result = rootNote + oct * 12 + q;
    return result;
}


// ------------------------------------------------------------
// 6. LED HELPERS
// ------------------------------------------------------------

inline function clearStepLeds() {
    // Main LEDs 1-16
    StepLED1.setValue(0);
    StepLED2.setValue(0);
    StepLED3.setValue(0);
    StepLED4.setValue(0);
    StepLED5.setValue(0);
    StepLED6.setValue(0);
    StepLED7.setValue(0);
    StepLED8.setValue(0);
    StepLED9.setValue(0);
    StepLED10.setValue(0);
    StepLED11.setValue(0);
    StepLED12.setValue(0);
    StepLED13.setValue(0);
    StepLED14.setValue(0);
    StepLED15.setValue(0);
    StepLED16.setValue(0);

    // Velocity LEDs 17-32
    StepLED17.setValue(0);
    StepLED18.setValue(0);
    StepLED19.setValue(0);
    StepLED20.setValue(0);
    StepLED21.setValue(0);
    StepLED22.setValue(0);
    StepLED23.setValue(0);
    StepLED24.setValue(0);
    StepLED25.setValue(0);
    StepLED26.setValue(0);
    StepLED27.setValue(0);
    StepLED28.setValue(0);
    StepLED29.setValue(0);
    StepLED30.setValue(0);
    StepLED31.setValue(0);
    StepLED32.setValue(0);

    // Custom 1 LEDs 33-48
    StepLED33.setValue(0);
    StepLED34.setValue(0);
    StepLED35.setValue(0);
    StepLED36.setValue(0);
    StepLED37.setValue(0);
    StepLED38.setValue(0);
    StepLED39.setValue(0);
    StepLED40.setValue(0);
    StepLED41.setValue(0);
    StepLED42.setValue(0);
    StepLED43.setValue(0);
    StepLED44.setValue(0);
    StepLED45.setValue(0);
    StepLED46.setValue(0);
    StepLED47.setValue(0);
    StepLED48.setValue(0);

    // Custom 2 LEDs 49-64
    StepLED49.setValue(0);
    StepLED50.setValue(0);
    StepLED51.setValue(0);
    StepLED52.setValue(0);
    StepLED53.setValue(0);
    StepLED54.setValue(0);
    StepLED55.setValue(0);
    StepLED56.setValue(0);
    StepLED57.setValue(0);
    StepLED58.setValue(0);
    StepLED59.setValue(0);
    StepLED60.setValue(0);
    StepLED61.setValue(0);
    StepLED62.setValue(0);
    StepLED63.setValue(0);
    StepLED64.setValue(0);

    // Custom 3 LEDs 81-96
    StepLED81.setValue(0);
    StepLED82.setValue(0);
    StepLED83.setValue(0);
    StepLED84.setValue(0);
    StepLED85.setValue(0);
    StepLED86.setValue(0);
    StepLED87.setValue(0);
    StepLED88.setValue(0);
    StepLED89.setValue(0);
    StepLED90.setValue(0);
    StepLED91.setValue(0);
    StepLED92.setValue(0);
    StepLED93.setValue(0);
    StepLED94.setValue(0);
    StepLED95.setValue(0);
    StepLED96.setValue(0);

    lastLedIndex = -1;
}

// ------------------------------------------------------------
// 7. START BUTTON LOOK
// ------------------------------------------------------------

inline function updateStartButtonLook() {
    if (isRunning) {
        StartButtonComponent.set("text", "STOP");
        StartButtonComponent.set("itemColour", 0xFF0037FF);
        StartButtonComponent.set("itemColour2", 0xFF05080B);
        StartButtonComponent.set("bgColour", 0xFF0037FF);
        StartButtonComponent.set("textColour", 0xFFFFFFFF);
    }
    else {
        StartButtonComponent.set("text", "PLAY");
        StartButtonComponent.set("itemColour", 0xFF303030);
        StartButtonComponent.set("itemColour2", 0xFF05080B);
        StartButtonComponent.set("bgColour", 0xFF05080B);
        StartButtonComponent.set("textColour", 0xFFB0B0B0);
    }
}

// ------------------------------------------------------------
// 8. SEQUENCER ENGINE (TIMER CALLBACK)
// ------------------------------------------------------------

inline function seqTimerCallback(timer) {
    if (!isRunning)
        return;

    // Clamp steps
    local maxSteps = activeSteps;
    if (maxSteps < 1) maxSteps = 1;
    else if (maxSteps > 16) maxSteps = 16;

    // Base forward index
    local base = stepIndex % maxSteps;
    local idx = 0;

    // Direction logic
    if (directionMode == 0)          // forward
    {
        idx = base;
    }
    else if (directionMode == 1)     // backward
    {
        idx = (maxSteps - 1) - base;
    }
    else if (directionMode == 2)     // ping-pong
    {
        if (maxSteps <= 1) {
            idx = 0;
        }
        else {
            local cycleLen = maxSteps * 2 - 2;
            local p = stepIndex % cycleLen;

            if (p < maxSteps)
                idx = p;
            else
                idx = (maxSteps * 2 - 2) - p;
        }
    }
    else                             // directionMode == 3, random
    {
        randSeed = randSeed * 1664525 + 1013904223 + stepIndex * 97;
        while (randSeed < 0)
            randSeed = randSeed + 2147483647;
        while (randSeed > 2147483647)
            randSeed = randSeed - 2147483647;

        if (randSeed < 0)
            randSeed = -randSeed;

        idx = randSeed % maxSteps;
    }

    // --------- UPDATE STEP LEDS (all LED rows) ---------
    if (lastLedIndex != idx) {
        // Turn off LEDs for previous step
        if (lastLedIndex == 0) {
            StepLED1.setValue(0);
            StepLED17.setValue(0);
            StepLED33.setValue(0);
            StepLED49.setValue(0);
            StepLED81.setValue(0);
        }
        else if (lastLedIndex == 1) {
            StepLED2.setValue(0);
            StepLED18.setValue(0);
            StepLED34.setValue(0);
            StepLED50.setValue(0);
            StepLED82.setValue(0);
        }
        else if (lastLedIndex == 2) {
            StepLED3.setValue(0);
            StepLED19.setValue(0);
            StepLED35.setValue(0);
            StepLED51.setValue(0);
            StepLED83.setValue(0);
        }
        else if (lastLedIndex == 3) {
            StepLED4.setValue(0);
            StepLED20.setValue(0);
            StepLED36.setValue(0);
            StepLED52.setValue(0);
            StepLED84.setValue(0);
        }
        else if (lastLedIndex == 4) {
            StepLED5.setValue(0);
            StepLED21.setValue(0);
            StepLED37.setValue(0);
            StepLED53.setValue(0);
            StepLED85.setValue(0);
        }
        else if (lastLedIndex == 5) {
            StepLED6.setValue(0);
            StepLED22.setValue(0);
            StepLED38.setValue(0);
            StepLED54.setValue(0);
            StepLED86.setValue(0);
        }
        else if (lastLedIndex == 6) {
            StepLED7.setValue(0);
            StepLED23.setValue(0);
            StepLED39.setValue(0);
            StepLED55.setValue(0);
            StepLED87.setValue(0);
        }
        else if (lastLedIndex == 7) {
            StepLED8.setValue(0);
            StepLED24.setValue(0);
            StepLED40.setValue(0);
            StepLED56.setValue(0);
            StepLED88.setValue(0);
        }
        else if (lastLedIndex == 8) {
            StepLED9.setValue(0);
            StepLED25.setValue(0);
            StepLED41.setValue(0);
            StepLED57.setValue(0);
            StepLED89.setValue(0);
        }
        else if (lastLedIndex == 9) {
            StepLED10.setValue(0);
            StepLED26.setValue(0);
            StepLED42.setValue(0);
            StepLED58.setValue(0);
            StepLED90.setValue(0);
        }
        else if (lastLedIndex == 10) {
            StepLED11.setValue(0);
            StepLED27.setValue(0);
            StepLED43.setValue(0);
            StepLED59.setValue(0);
            StepLED91.setValue(0);
        }
        else if (lastLedIndex == 11) {
            StepLED12.setValue(0);
            StepLED28.setValue(0);
            StepLED44.setValue(0);
            StepLED60.setValue(0);
            StepLED92.setValue(0);
        }
        else if (lastLedIndex == 12) {
            StepLED13.setValue(0);
            StepLED29.setValue(0);
            StepLED45.setValue(0);
            StepLED61.setValue(0);
            StepLED93.setValue(0);
        }
        else if (lastLedIndex == 13) {
            StepLED14.setValue(0);
            StepLED30.setValue(0);
            StepLED46.setValue(0);
            StepLED62.setValue(0);
            StepLED94.setValue(0);
        }
        else if (lastLedIndex == 14) {
            StepLED15.setValue(0);
            StepLED31.setValue(0);
            StepLED47.setValue(0);
            StepLED63.setValue(0);
            StepLED95.setValue(0);
        }
        else if (lastLedIndex == 15) {
            StepLED16.setValue(0);
            StepLED32.setValue(0);
            StepLED48.setValue(0);
            StepLED64.setValue(0);
            StepLED96.setValue(0);
        }

        // Turn on LEDs for current step
        if (idx == 0) {
            StepLED1.setValue(1);
            StepLED17.setValue(1);
            StepLED33.setValue(1);
            StepLED49.setValue(1);
            StepLED81.setValue(1);
        }
        else if (idx == 1) {
            StepLED2.setValue(1);
            StepLED18.setValue(1);
            StepLED34.setValue(1);
            StepLED50.setValue(1);
            StepLED82.setValue(1);
        }
        else if (idx == 2) {
            StepLED3.setValue(1);
            StepLED19.setValue(1);
            StepLED35.setValue(1);
            StepLED51.setValue(1);
            StepLED83.setValue(1);
        }
        else if (idx == 3) {
            StepLED4.setValue(1);
            StepLED20.setValue(1);
            StepLED36.setValue(1);
            StepLED52.setValue(1);
            StepLED84.setValue(1);
        }
        else if (idx == 4) {
            StepLED5.setValue(1);
            StepLED21.setValue(1);
            StepLED37.setValue(1);
            StepLED53.setValue(1);
            StepLED85.setValue(1);
        }
        else if (idx == 5) {
            StepLED6.setValue(1);
            StepLED22.setValue(1);
            StepLED38.setValue(1);
            StepLED54.setValue(1);
            StepLED86.setValue(1);
        }
        else if (idx == 6) {
            StepLED7.setValue(1);
            StepLED23.setValue(1);
            StepLED39.setValue(1);
            StepLED55.setValue(1);
            StepLED87.setValue(1);
        }
        else if (idx == 7) {
            StepLED8.setValue(1);
            StepLED24.setValue(1);
            StepLED40.setValue(1);
            StepLED56.setValue(1);
            StepLED88.setValue(1);
        }
        else if (idx == 8) {
            StepLED9.setValue(1);
            StepLED25.setValue(1);
            StepLED41.setValue(1);
            StepLED57.setValue(1);
            StepLED89.setValue(1);
        }
        else if (idx == 9) {
            StepLED10.setValue(1);
            StepLED26.setValue(1);
            StepLED42.setValue(1);
            StepLED58.setValue(1);
            StepLED90.setValue(1);
        }
        else if (idx == 10) {
            StepLED11.setValue(1);
            StepLED27.setValue(1);
            StepLED43.setValue(1);
            StepLED59.setValue(1);
            StepLED91.setValue(1);
        }
        else if (idx == 11) {
            StepLED12.setValue(1);
            StepLED28.setValue(1);
            StepLED44.setValue(1);
            StepLED60.setValue(1);
            StepLED92.setValue(1);
        }
        else if (idx == 12) {
            StepLED13.setValue(1);
            StepLED29.setValue(1);
            StepLED45.setValue(1);
            StepLED61.setValue(1);
            StepLED93.setValue(1);
        }
        else if (idx == 13) {
            StepLED14.setValue(1);
            StepLED30.setValue(1);
            StepLED46.setValue(1);
            StepLED62.setValue(1);
            StepLED94.setValue(1);
        }
        else if (idx == 14) {
            StepLED15.setValue(1);
            StepLED31.setValue(1);
            StepLED47.setValue(1);
            StepLED63.setValue(1);
            StepLED95.setValue(1);
        }
        else if (idx == 15) {
            StepLED16.setValue(1);
            StepLED32.setValue(1);
            StepLED48.setValue(1);
            StepLED64.setValue(1);
            StepLED96.setValue(1);
        }

        lastLedIndex = idx;
    }


    // Pitch / gate for this step
    local pitch = rootNote;
    local gate = 0;
    local velocity = 100; //default velocity if nothing is set

    if (idx == 0) { pitch += step1Pitch; gate = step1Gate; velocity = step1Velocity; }
    else if (idx == 1) { pitch += step2Pitch; gate = step2Gate; velocity = step2Velocity; }
    else if (idx == 2) { pitch += step3Pitch; gate = step3Gate; velocity = step3Velocity; }
    else if (idx == 3) { pitch += step4Pitch; gate = step4Gate; velocity = step4Velocity; }
    else if (idx == 4) { pitch += step5Pitch; gate = step5Gate; velocity = step5Velocity; }
    else if (idx == 5) { pitch += step6Pitch; gate = step6Gate; velocity = step6Velocity; }
    else if (idx == 6) { pitch += step7Pitch; gate = step7Gate; velocity = step7Velocity; }
    else if (idx == 7) { pitch += step8Pitch; gate = step8Gate; velocity = step8Velocity; }
    else if (idx == 8) { pitch += step9Pitch; gate = step9Gate; velocity = step9Velocity; }
    else if (idx == 9) { pitch += step10Pitch; gate = step10Gate; velocity = step10Velocity; }
    else if (idx == 10) { pitch += step11Pitch; gate = step11Gate; velocity = step11Velocity; }
    else if (idx == 11) { pitch += step12Pitch; gate = step12Gate; velocity = step12Velocity; }
    else if (idx == 12) { pitch += step13Pitch; gate = step13Gate; velocity = step13Velocity; }
    else if (idx == 13) { pitch += step14Pitch; gate = step14Gate; velocity = step14Velocity; }
    else if (idx == 14) { pitch += step15Pitch; gate = step15Gate; velocity = step15Velocity; }
    else if (idx == 15) { pitch += step16Pitch; gate = step16Gate; velocity = step16Velocity; }


    // Quantize if needed
    pitch = quantizePitchToMode(pitch);

    // Gate / note handling - using proper MIDI note tracking
    // First, turn off only the previous note (not all notes!)
    if (lastNote != -1) {
        Synth.addNoteOff(lastChannel, lastNote, 0);
        lastNote = -1;
    }

    if (gate == 1) {
        if (velocity < 1) velocity = 1;
        else if (velocity > 127) velocity = 127;

        // Use addNoteOn for proper MIDI FX output
        Synth.addNoteOn(lastChannel, pitch, velocity, 0);
        lastNote = pitch;
        Console.print("STEP " + stepIndex + " (idx " + idx + ") -> note " + pitch);
    }
    else {
        Console.print("STEP " + stepIndex + " (idx " + idx + ") (muted)");
    }

    stepIndex += 1;

    // ---- Custom lanes: always send every step (gate does NOT affect this) ----
    local c1 = 0;
    local c2 = 0;
    local c3 = 0;

    if (idx == 0) { c1 = step1Custom1; c2 = step1Custom2; c3 = step1Custom3; }
    else if (idx == 1) { c1 = step2Custom1; c2 = step2Custom2; c3 = step2Custom3; }
    else if (idx == 2) { c1 = step3Custom1; c2 = step3Custom2; c3 = step3Custom3; }
    else if (idx == 3) { c1 = step4Custom1; c2 = step4Custom2; c3 = step4Custom3; }
    else if (idx == 4) { c1 = step5Custom1; c2 = step5Custom2; c3 = step5Custom3; }
    else if (idx == 5) { c1 = step6Custom1; c2 = step6Custom2; c3 = step6Custom3; }
    else if (idx == 6) { c1 = step7Custom1; c2 = step7Custom2; c3 = step7Custom3; }
    else if (idx == 7) { c1 = step8Custom1; c2 = step8Custom2; c3 = step8Custom3; }
    else if (idx == 8) { c1 = step9Custom1; c2 = step9Custom2; c3 = step9Custom3; }
    else if (idx == 9) { c1 = step10Custom1; c2 = step10Custom2; c3 = step10Custom3; }
    else if (idx == 10) { c1 = step11Custom1; c2 = step11Custom2; c3 = step11Custom3; }
    else if (idx == 11) { c1 = step12Custom1; c2 = step12Custom2; c3 = step12Custom3; }
    else if (idx == 12) { c1 = step13Custom1; c2 = step13Custom2; c3 = step13Custom3; }
    else if (idx == 13) { c1 = step14Custom1; c2 = step14Custom2; c3 = step14Custom3; }
    else if (idx == 14) { c1 = step15Custom1; c2 = step15Custom2; c3 = step15Custom3; }
    else if (idx == 15) { c1 = step16Custom1; c2 = step16Custom2; c3 = step16Custom3; }

    c1 = clamp127(c1);
    c2 = clamp127(c2);
    c3 = clamp127(c3);
    
    local ch = 1;

    Synth.addController(ch, CUSTOM1_CC, c1, 0);
    Synth.addController(ch, CUSTOM2_CC, c2, 0);
    Synth.addController(ch, CUSTOM3_CC, c3, 0);

}

// Attach timer callback
seqTimer.setTimerCallback(seqTimerCallback);

// Update timer interval when tempo or division changes
inline function updateStepTimer() {
    local bpm = getEffectiveBpm();
    local intervalMs = (60000 / bpm) / divisionFactor;

    if (isRunning)
        seqTimer.startTimer(intervalMs);
}

// ------------------------------------------------------------
// 9. UI CALLBACKS
// ------------------------------------------------------------

inline function RandAmountCallback(component, value) {
    randomAmount = value; // expecting 0..100
}

// Start / stop
inline function StartButtonCallback(component, value) {
    isRunning = (value > 0.5);

    if (isRunning) {
        stepIndex = 0;
        randSeed = Engine.getUptime()
            + tempoBPM * 17
            + activeSteps * 37
            + step1Pitch * 101
            + step2Pitch * 103
            + step3Pitch * 107;

        local bpm = getEffectiveBpm();
        local intervalMs = (60000 / bpm) / divisionFactor;
        seqTimer.startTimer(intervalMs);
    }
    else {
        seqTimer.stopTimer();
        isRunning = false;

        // Turn off the last playing note
        if (lastNote != -1) {
            Synth.addNoteOff(lastChannel, lastNote, 0);
            lastNote = -1;
        }

        // Also call allNotesOff as a safety net (only once on stop, so no audio cut issues)
        Engine.allNotesOff();
        clearStepLeds();
    }

    updateStartButtonLook();
}

// Tempo knob
inline function TempoKnobCallback(component, value) {
    tempoBPM = value;
    updateStepTimer();
    updateBpmLabel();
}

// Division selector
inline function DivisionSelectorCallback(component, value) {
    // Combo items: 1: "1/4", 2: "1/8", 3: "1/16", 4: "1/32"
    if (value == 1)
        divisionFactor = 1;   // quarter notes
    else if (value == 2)
        divisionFactor = 2;   // eighth notes
    else if (value == 3)
        divisionFactor = 4;   // sixteenth notes
    else if (value == 4)
        divisionFactor = 8;   // thirty-second notes
    else
        divisionFactor = 4;   // fallback to 1/16

    updateStepTimer();
}

// Sync toggle (host vs internal tempo)
inline function SyncToggleCallback(component, value) {
    useHostTempo = (value > 0.5 ? 1 : 0);
    updateStepTimer();
}

// Steps active
inline function StepsActiveCallback(component, value) {
    if (value < 1) value = 1;
    else if (value > 16) value = 16;

    activeSteps = value;
}

// Direction buttons (icons)

inline function DirForwardCallback(component, value) {
    if (value <= 0.5)
        return;

    directionMode = 0;   // forward
    Console.print("Direction = FORWARD");
}

inline function DirBackwardCallback(component, value) {
    if (value <= 0.5)
        return;

    directionMode = 1;   // backward
    Console.print("Direction = BACKWARD");
}

inline function DirPingPongCallback(component, value) {
    if (value <= 0.5)
        return;

    directionMode = 2;   // mirror / ping-pong
    Console.print("Direction = PING-PONG");
}

inline function DirRandomCallback(component, value) {
    if (value <= 0.5)
        return;

    directionMode = 3;   // random
    Console.print("Direction = RANDOM");
}

// Randomization buttons

inline function RandPitchCallback(component, value) {
    if (value <= 0.5) return;
    randomizePitchAll();
    component.setValue(0); // momentary
}

inline function RandGateCallback(component, value) {
    if (value <= 0.5) return;
    randomizeGateAll();
    component.setValue(0);
}

inline function RandBothCallback(component, value) {
    if (value <= 0.5) return;
    randomizePitchAll();
    randomizeGateAll();
    component.setValue(0);
}

// Pitch callbacks
inline function Step1PitchCallback(component, value) { step1Pitch = value; }
inline function Step2PitchCallback(component, value) { step2Pitch = value; }
inline function Step3PitchCallback(component, value) { step3Pitch = value; }
inline function Step4PitchCallback(component, value) { step4Pitch = value; }
inline function Step5PitchCallback(component, value) { step5Pitch = value; }
inline function Step6PitchCallback(component, value) { step6Pitch = value; }
inline function Step7PitchCallback(component, value) { step7Pitch = value; }
inline function Step8PitchCallback(component, value) { step8Pitch = value; }
inline function Step9PitchCallback(component, value) { step9Pitch = value; }
inline function Step10PitchCallback(component, value) { step10Pitch = value; }
inline function Step11PitchCallback(component, value) { step11Pitch = value; }
inline function Step12PitchCallback(component, value) { step12Pitch = value; }
inline function Step13PitchCallback(component, value) { step13Pitch = value; }
inline function Step14PitchCallback(component, value) { step14Pitch = value; }
inline function Step15PitchCallback(component, value) { step15Pitch = value; }
inline function Step16PitchCallback(component, value) { step16Pitch = value; }

// Gate callbacks
inline function Step1GateCallback(component, value) { step1Gate = (value > 0.5 ? 1 : 0); }
inline function Step2GateCallback(component, value) { step2Gate = (value > 0.5 ? 1 : 0); }
inline function Step3GateCallback(component, value) { step3Gate = (value > 0.5 ? 1 : 0); }
inline function Step4GateCallback(component, value) { step4Gate = (value > 0.5 ? 1 : 0); }
inline function Step5GateCallback(component, value) { step5Gate = (value > 0.5 ? 1 : 0); }
inline function Step6GateCallback(component, value) { step6Gate = (value > 0.5 ? 1 : 0); }
inline function Step7GateCallback(component, value) { step7Gate = (value > 0.5 ? 1 : 0); }
inline function Step8GateCallback(component, value) { step8Gate = (value > 0.5 ? 1 : 0); }
inline function Step9GateCallback(component, value) { step9Gate = (value > 0.5 ? 1 : 0); }
inline function Step10GateCallback(component, value) { step10Gate = (value > 0.5 ? 1 : 0); }
inline function Step11GateCallback(component, value) { step11Gate = (value > 0.5 ? 1 : 0); }
inline function Step12GateCallback(component, value) { step12Gate = (value > 0.5 ? 1 : 0); }
inline function Step13GateCallback(component, value) { step13Gate = (value > 0.5 ? 1 : 0); }
inline function Step14GateCallback(component, value) { step14Gate = (value > 0.5 ? 1 : 0); }
inline function Step15GateCallback(component, value) { step15Gate = (value > 0.5 ? 1 : 0); }
inline function Step16GateCallback(component, value) { step16Gate = (value > 0.5 ? 1 : 0); }

// Velocity callbacks
inline function Step1VelocityCallback(component, value) { step1Velocity = value; }
inline function Step2VelocityCallback(component, value) { step2Velocity = value; }
inline function Step3VelocityCallback(component, value) { step3Velocity = value; }
inline function Step4VelocityCallback(component, value) { step4Velocity = value; }
inline function Step5VelocityCallback(component, value) { step5Velocity = value; }
inline function Step6VelocityCallback(component, value) { step6Velocity = value; }
inline function Step7VelocityCallback(component, value) { step7Velocity = value; }
inline function Step8VelocityCallback(component, value) { step8Velocity = value; }
inline function Step9VelocityCallback(component, value) { step9Velocity = value; }
inline function Step10VelocityCallback(component, value) { step10Velocity = value; }
inline function Step11VelocityCallback(component, value) { step11Velocity = value; }
inline function Step12VelocityCallback(component, value) { step12Velocity = value; }
inline function Step13VelocityCallback(component, value) { step13Velocity = value; }
inline function Step14VelocityCallback(component, value) { step14Velocity = value; }
inline function Step15VelocityCallback(component, value) { step15Velocity = value; }
inline function Step16VelocityCallback(component, value) { step16Velocity = value; }

// --- Custom 1 callbacks ---
inline function Step1Custom1Callback(component, value) { step1Custom1 = value; }
inline function Step2Custom1Callback(component, value) { step2Custom1 = value; }
inline function Step3Custom1Callback(component, value) { step3Custom1 = value; }
inline function Step4Custom1Callback(component, value) { step4Custom1 = value; }
inline function Step5Custom1Callback(component, value) { step5Custom1 = value; }
inline function Step6Custom1Callback(component, value) { step6Custom1 = value; }
inline function Step7Custom1Callback(component, value) { step7Custom1 = value; }
inline function Step8Custom1Callback(component, value) { step8Custom1 = value; }
inline function Step9Custom1Callback(component, value) { step9Custom1 = value; }
inline function Step10Custom1Callback(component, value) { step10Custom1 = value; }
inline function Step11Custom1Callback(component, value) { step11Custom1 = value; }
inline function Step12Custom1Callback(component, value) { step12Custom1 = value; }
inline function Step13Custom1Callback(component, value) { step13Custom1 = value; }
inline function Step14Custom1Callback(component, value) { step14Custom1 = value; }
inline function Step15Custom1Callback(component, value) { step15Custom1 = value; }
inline function Step16Custom1Callback(component, value) { step16Custom1 = value; }

// --- Custom 2 callbacks ---
inline function Step1Custom2Callback(component, value) { step1Custom2 = value; }
inline function Step2Custom2Callback(component, value) { step2Custom2 = value; }
inline function Step3Custom2Callback(component, value) { step3Custom2 = value; }
inline function Step4Custom2Callback(component, value) { step4Custom2 = value; }
inline function Step5Custom2Callback(component, value) { step5Custom2 = value; }
inline function Step6Custom2Callback(component, value) { step6Custom2 = value; }
inline function Step7Custom2Callback(component, value) { step7Custom2 = value; }
inline function Step8Custom2Callback(component, value) { step8Custom2 = value; }
inline function Step9Custom2Callback(component, value) { step9Custom2 = value; }
inline function Step10Custom2Callback(component, value) { step10Custom2 = value; }
inline function Step11Custom2Callback(component, value) { step11Custom2 = value; }
inline function Step12Custom2Callback(component, value) { step12Custom2 = value; }
inline function Step13Custom2Callback(component, value) { step13Custom2 = value; }
inline function Step14Custom2Callback(component, value) { step14Custom2 = value; }
inline function Step15Custom2Callback(component, value) { step15Custom2 = value; }
inline function Step16Custom2Callback(component, value) { step16Custom2 = value; }

// --- Custom 3 callbacks ---
inline function Step1Custom3Callback(component, value) { step1Custom3 = value; }
inline function Step2Custom3Callback(component, value) { step2Custom3 = value; }
inline function Step3Custom3Callback(component, value) { step3Custom3 = value; }
inline function Step4Custom3Callback(component, value) { step4Custom3 = value; }
inline function Step5Custom3Callback(component, value) { step5Custom3 = value; }
inline function Step6Custom3Callback(component, value) { step6Custom3 = value; }
inline function Step7Custom3Callback(component, value) { step7Custom3 = value; }
inline function Step8Custom3Callback(component, value) { step8Custom3 = value; }
inline function Step9Custom3Callback(component, value) { step9Custom3 = value; }
inline function Step10Custom3Callback(component, value) { step10Custom3 = value; }
inline function Step11Custom3Callback(component, value) { step11Custom3 = value; }
inline function Step12Custom3Callback(component, value) { step12Custom3 = value; }
inline function Step13Custom3Callback(component, value) { step13Custom3 = value; }
inline function Step14Custom3Callback(component, value) { step14Custom3 = value; }
inline function Step15Custom3Callback(component, value) { step15Custom3 = value; }
inline function Step16Custom3Callback(component, value) { step16Custom3 = value; }


// Scale / key / octave callbacks

inline function RootNoteCallback(component, value) {
    rootNote = value;
}

inline function ScaleModeCallback(component, value) {
    local m = value;

    // ComboBox: 1..9 => 0..8
    if (m >= 1 && m <= 9)
        m = m - 1;

    if (m < 0) m = 0;
    else if (m > 8) m = 8;

    scaleMode = m;
}

inline function KeySelectorCallback(component, value) {
    local k = value;

    if (k >= 1 && k <= 12)
        k = k - 1;

    if (k < 0) k = 0;
    else if (k > 11) k = 11;

    rootNote = 60 + k; // C4 + pitch class
}

inline function OctaveRangeCallback(component, value) {
    local v = value;

    if (v < 1) v = 1;
    else if (v > 5) v = 5;

    octaveRange = v;

    local maxSemis = v * 12;
    local minSemis = -maxSemis;

    local c;

    c = Content.getComponent("Step1Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step2Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step3Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step4Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step5Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step6Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step7Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step8Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step9Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step10Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step11Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step12Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step13Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step14Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step15Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
    c = Content.getComponent("Step16Pitch"); c.set("min", minSemis); c.set("max", maxSemis);
}

// Custom page callbacks

inline function LearnCustom1Callback(component, value) {
    learnCustom1Armed = (value > 0.5);

    updateLearnLabel();

    if (anyLearnArmed()) {
        // Start learn sender at ~6–7 Hz
        learnTimer.startTimer(150);
        // Send immediately so user doesn’t have to wait
        sendLearnBurst();
    }
    else {
        learnTimer.stopTimer();
    }
}

inline function LearnCustom2Callback(component, value) {
    learnCustom2Armed = (value > 0.5);

    updateLearnLabel();

    if (anyLearnArmed()) {
        learnTimer.startTimer(150);
        sendLearnBurst();
    }
    else {
        learnTimer.stopTimer();
    }
}

inline function LearnCustom3Callback(component, value) {
    learnCustom3Armed = (value > 0.5);

    updateLearnLabel();

    if (anyLearnArmed()) {
        learnTimer.startTimer(150);
        sendLearnBurst();
    }
    else {
        learnTimer.stopTimer();
    }
}



// ------------------------------------------------------------
// 10. INIT: ATTACH CALLBACKS & DEFAULTS
// ------------------------------------------------------------

inline function onInit() {
    tempoBPM = 120;
    stepIndex = 0;
    isRunning = false;

    // UI components
    local StartButton = Content.getComponent("StartButton");
    local TempoKnob = Content.getComponent("TempoKnob");
    local StepsActive = Content.getComponent("StepsActive");
    local ScaleModeComp = Content.getComponent("ScaleMode");
    local KeySelectorComp = Content.getComponent("KeySelector");
    local SyncToggle = Content.getComponent("SyncToggle");
    local DivisionSelector = Content.getComponent("DivisionSelector");

    local DirForward = Content.getComponent("DirForward");
    local DirBackward = Content.getComponent("DirBackward");
    local DirPingPong = Content.getComponent("DirPingPong");
    local DirRandom = Content.getComponent("DirRandom");

    local RandPitch = Content.getComponent("RandPitch");
    local RandGate = Content.getComponent("RandGate");
    local RandBoth = Content.getComponent("RandBoth");
    local RandAmount = Content.getComponent("RandAmount");
    local OctaveRange = Content.getComponent("OctaveRange");

    local Step1PitchComp = Content.getComponent("Step1Pitch");
    local Step2PitchComp = Content.getComponent("Step2Pitch");
    local Step3PitchComp = Content.getComponent("Step3Pitch");
    local Step4PitchComp = Content.getComponent("Step4Pitch");
    local Step5PitchComp = Content.getComponent("Step5Pitch");
    local Step6PitchComp = Content.getComponent("Step6Pitch");
    local Step7PitchComp = Content.getComponent("Step7Pitch");
    local Step8PitchComp = Content.getComponent("Step8Pitch");
    local Step9PitchComp = Content.getComponent("Step9Pitch");
    local Step10PitchComp = Content.getComponent("Step10Pitch");
    local Step11PitchComp = Content.getComponent("Step11Pitch");
    local Step12PitchComp = Content.getComponent("Step12Pitch");
    local Step13PitchComp = Content.getComponent("Step13Pitch");
    local Step14PitchComp = Content.getComponent("Step14Pitch");
    local Step15PitchComp = Content.getComponent("Step15Pitch");
    local Step16PitchComp = Content.getComponent("Step16Pitch");

    local Step1GateComp = Content.getComponent("Step1Gate");
    local Step2GateComp = Content.getComponent("Step2Gate");
    local Step3GateComp = Content.getComponent("Step3Gate");
    local Step4GateComp = Content.getComponent("Step4Gate");
    local Step5GateComp = Content.getComponent("Step5Gate");
    local Step6GateComp = Content.getComponent("Step6Gate");
    local Step7GateComp = Content.getComponent("Step7Gate");
    local Step8GateComp = Content.getComponent("Step8Gate");
    local Step9GateComp = Content.getComponent("Step9Gate");
    local Step10GateComp = Content.getComponent("Step10Gate");
    local Step11GateComp = Content.getComponent("Step11Gate");
    local Step12GateComp = Content.getComponent("Step12Gate");
    local Step13GateComp = Content.getComponent("Step13Gate");
    local Step14GateComp = Content.getComponent("Step14Gate");
    local Step15GateComp = Content.getComponent("Step15Gate");
    local Step16GateComp = Content.getComponent("Step16Gate");
       
    local Step1Velocity = Content.getComponent("Step1Velocity");
    local Step2Velocity = Content.getComponent("Step2Velocity");
    local Step3Velocity = Content.getComponent("Step3Velocity");
    local Step4Velocity = Content.getComponent("Step4Velocity");
    local Step5Velocity = Content.getComponent("Step5Velocity");
    local Step6Velocity = Content.getComponent("Step6Velocity");
    local Step7Velocity = Content.getComponent("Step7Velocity");
    local Step8Velocity = Content.getComponent("Step8Velocity");
    local Step9Velocity = Content.getComponent("Step9Velocity");
    local Step10Velocity = Content.getComponent("Step10Velocity");
    local Step11Velocity = Content.getComponent("Step11Velocity");
    local Step12Velocity = Content.getComponent("Step12Velocity");
    local Step13Velocity = Content.getComponent("Step13Velocity");
    local Step14Velocity = Content.getComponent("Step14Velocity");
    local Step15Velocity = Content.getComponent("Step15Velocity");
    local Step16Velocity = Content.getComponent("Step16Velocity");

    // Custom 1 knobs
    local Step1Custom1 = Content.getComponent("Step1Custom1");
    local Step2Custom1 = Content.getComponent("Step2Custom1");
    local Step3Custom1 = Content.getComponent("Step3Custom1");
    local Step4Custom1 = Content.getComponent("Step4Custom1");
    local Step5Custom1 = Content.getComponent("Step5Custom1");
    local Step6Custom1 = Content.getComponent("Step6Custom1");
    local Step7Custom1 = Content.getComponent("Step7Custom1");
    local Step8Custom1 = Content.getComponent("Step8Custom1");
    local Step9Custom1 = Content.getComponent("Step9Custom1");
    local Step10Custom1 = Content.getComponent("Step10Custom1");
    local Step11Custom1 = Content.getComponent("Step11Custom1");
    local Step12Custom1 = Content.getComponent("Step12Custom1");
    local Step13Custom1 = Content.getComponent("Step13Custom1");
    local Step14Custom1 = Content.getComponent("Step14Custom1");
    local Step15Custom1 = Content.getComponent("Step15Custom1");
    local Step16Custom1 = Content.getComponent("Step16Custom1");

    // Custom 2 knobs
    local Step1Custom2 = Content.getComponent("Step1Custom2");
    local Step2Custom2 = Content.getComponent("Step2Custom2");
    local Step3Custom2 = Content.getComponent("Step3Custom2");
    local Step4Custom2 = Content.getComponent("Step4Custom2");
    local Step5Custom2 = Content.getComponent("Step5Custom2");
    local Step6Custom2 = Content.getComponent("Step6Custom2");
    local Step7Custom2 = Content.getComponent("Step7Custom2");
    local Step8Custom2 = Content.getComponent("Step8Custom2");
    local Step9Custom2 = Content.getComponent("Step9Custom2");
    local Step10Custom2 = Content.getComponent("Step10Custom2");
    local Step11Custom2 = Content.getComponent("Step11Custom2");
    local Step12Custom2 = Content.getComponent("Step12Custom2");
    local Step13Custom2 = Content.getComponent("Step13Custom2");
    local Step14Custom2 = Content.getComponent("Step14Custom2");
    local Step15Custom2 = Content.getComponent("Step15Custom2");
    local Step16Custom2 = Content.getComponent("Step16Custom2");

    // Custom 3 knobs
    local Step1Custom3 = Content.getComponent("Step1Custom3");
    local Step2Custom3 = Content.getComponent("Step2Custom3");
    local Step3Custom3 = Content.getComponent("Step3Custom3");
    local Step4Custom3 = Content.getComponent("Step4Custom3");
    local Step5Custom3 = Content.getComponent("Step5Custom3");
    local Step6Custom3 = Content.getComponent("Step6Custom3");
    local Step7Custom3 = Content.getComponent("Step7Custom3");
    local Step8Custom3 = Content.getComponent("Step8Custom3");
    local Step9Custom3 = Content.getComponent("Step9Custom3");
    local Step10Custom3 = Content.getComponent("Step10Custom3");
    local Step11Custom3 = Content.getComponent("Step11Custom3");
    local Step12Custom3 = Content.getComponent("Step12Custom3");
    local Step13Custom3 = Content.getComponent("Step13Custom3");
    local Step14Custom3 = Content.getComponent("Step14Custom3");
    local Step15Custom3 = Content.getComponent("Step15Custom3");
    local Step16Custom3 = Content.getComponent("Step16Custom3");


    // Attach callbacks
    StartButton.setControlCallback(StartButtonCallback);
    TempoKnob.setControlCallback(TempoKnobCallback);
    StepsActive.setControlCallback(StepsActiveCallback);
    ScaleModeComp.setControlCallback(ScaleModeCallback);
    KeySelectorComp.setControlCallback(KeySelectorCallback);
    SyncToggle.setControlCallback(SyncToggleCallback);
    DivisionSelector.setControlCallback(DivisionSelectorCallback);

    DirForward.setControlCallback(DirForwardCallback);
    DirBackward.setControlCallback(DirBackwardCallback);
    DirPingPong.setControlCallback(DirPingPongCallback);
    DirRandom.setControlCallback(DirRandomCallback);

    RandPitch.setControlCallback(RandPitchCallback);
    RandGate.setControlCallback(RandGateCallback);
    RandBoth.setControlCallback(RandBothCallback);
    RandAmount.setControlCallback(RandAmountCallback);

    OctaveRange.setControlCallback(OctaveRangeCallback);

    LearnCustom1Btn.setControlCallback(LearnCustom1Callback);
    LearnCustom2Btn.setControlCallback(LearnCustom2Callback);
    LearnCustom3Btn.setControlCallback(LearnCustom3Callback);

    // Optional: make sure label starts empty
    LearnStatusLabel.set("text", "");


    Step1PitchComp.setControlCallback(Step1PitchCallback);
    Step2PitchComp.setControlCallback(Step2PitchCallback);
    Step3PitchComp.setControlCallback(Step3PitchCallback);
    Step4PitchComp.setControlCallback(Step4PitchCallback);
    Step5PitchComp.setControlCallback(Step5PitchCallback);
    Step6PitchComp.setControlCallback(Step6PitchCallback);
    Step7PitchComp.setControlCallback(Step7PitchCallback);
    Step8PitchComp.setControlCallback(Step8PitchCallback);
    Step9PitchComp.setControlCallback(Step9PitchCallback);
    Step10PitchComp.setControlCallback(Step10PitchCallback);
    Step11PitchComp.setControlCallback(Step11PitchCallback);
    Step12PitchComp.setControlCallback(Step12PitchCallback);
    Step13PitchComp.setControlCallback(Step13PitchCallback);
    Step14PitchComp.setControlCallback(Step14PitchCallback);
    Step15PitchComp.setControlCallback(Step15PitchCallback);
    Step16PitchComp.setControlCallback(Step16PitchCallback);

    Step1GateComp.setControlCallback(Step1GateCallback);
    Step2GateComp.setControlCallback(Step2GateCallback);
    Step3GateComp.setControlCallback(Step3GateCallback);
    Step4GateComp.setControlCallback(Step4GateCallback);
    Step5GateComp.setControlCallback(Step5GateCallback);
    Step6GateComp.setControlCallback(Step6GateCallback);
    Step7GateComp.setControlCallback(Step7GateCallback);
    Step8GateComp.setControlCallback(Step8GateCallback);
    Step9GateComp.setControlCallback(Step9GateCallback);
    Step10GateComp.setControlCallback(Step10GateCallback);
    Step11GateComp.setControlCallback(Step11GateCallback);
    Step12GateComp.setControlCallback(Step12GateCallback);
    Step13GateComp.setControlCallback(Step13GateCallback);
    Step14GateComp.setControlCallback(Step14GateCallback);
    Step15GateComp.setControlCallback(Step15GateCallback);
    Step16GateComp.setControlCallback(Step16GateCallback);

    Step1Velocity.setControlCallback(Step1VelocityCallback);
    Step2Velocity.setControlCallback(Step2VelocityCallback);
    Step3Velocity.setControlCallback(Step3VelocityCallback);
    Step4Velocity.setControlCallback(Step4VelocityCallback);
    Step5Velocity.setControlCallback(Step5VelocityCallback);
    Step6Velocity.setControlCallback(Step6VelocityCallback);
    Step7Velocity.setControlCallback(Step7VelocityCallback);
    Step8Velocity.setControlCallback(Step8VelocityCallback);
    Step9Velocity.setControlCallback(Step9VelocityCallback);
    Step10Velocity.setControlCallback(Step10VelocityCallback);
    Step11Velocity.setControlCallback(Step11VelocityCallback);
    Step12Velocity.setControlCallback(Step12VelocityCallback);
    Step13Velocity.setControlCallback(Step13VelocityCallback);
    Step14Velocity.setControlCallback(Step14VelocityCallback);
    Step15Velocity.setControlCallback(Step15VelocityCallback);
    Step16Velocity.setControlCallback(Step16VelocityCallback);

    // Custom 1 callbacks
    Step1Custom1.setControlCallback(Step1Custom1Callback);
    Step2Custom1.setControlCallback(Step2Custom1Callback);
    Step3Custom1.setControlCallback(Step3Custom1Callback);
    Step4Custom1.setControlCallback(Step4Custom1Callback);
    Step5Custom1.setControlCallback(Step5Custom1Callback);
    Step6Custom1.setControlCallback(Step6Custom1Callback);
    Step7Custom1.setControlCallback(Step7Custom1Callback);
    Step8Custom1.setControlCallback(Step8Custom1Callback);
    Step9Custom1.setControlCallback(Step9Custom1Callback);
    Step10Custom1.setControlCallback(Step10Custom1Callback);
    Step11Custom1.setControlCallback(Step11Custom1Callback);
    Step12Custom1.setControlCallback(Step12Custom1Callback);
    Step13Custom1.setControlCallback(Step13Custom1Callback);
    Step14Custom1.setControlCallback(Step14Custom1Callback);
    Step15Custom1.setControlCallback(Step15Custom1Callback);
    Step16Custom1.setControlCallback(Step16Custom1Callback);

    // Custom 2 callbacks
    Step1Custom2.setControlCallback(Step1Custom2Callback);
    Step2Custom2.setControlCallback(Step2Custom2Callback);
    Step3Custom2.setControlCallback(Step3Custom2Callback);
    Step4Custom2.setControlCallback(Step4Custom2Callback);
    Step5Custom2.setControlCallback(Step5Custom2Callback);
    Step6Custom2.setControlCallback(Step6Custom2Callback);
    Step7Custom2.setControlCallback(Step7Custom2Callback);
    Step8Custom2.setControlCallback(Step8Custom2Callback);
    Step9Custom2.setControlCallback(Step9Custom2Callback);
    Step10Custom2.setControlCallback(Step10Custom2Callback);
    Step11Custom2.setControlCallback(Step11Custom2Callback);
    Step12Custom2.setControlCallback(Step12Custom2Callback);
    Step13Custom2.setControlCallback(Step13Custom2Callback);
    Step14Custom2.setControlCallback(Step14Custom2Callback);
    Step15Custom2.setControlCallback(Step15Custom2Callback);
    Step16Custom2.setControlCallback(Step16Custom2Callback);

    // Custom 3 callbacks
    Step1Custom3.setControlCallback(Step1Custom3Callback);
    Step2Custom3.setControlCallback(Step2Custom3Callback);
    Step3Custom3.setControlCallback(Step3Custom3Callback);
    Step4Custom3.setControlCallback(Step4Custom3Callback);
    Step5Custom3.setControlCallback(Step5Custom3Callback);
    Step6Custom3.setControlCallback(Step6Custom3Callback);
    Step7Custom3.setControlCallback(Step7Custom3Callback);
    Step8Custom3.setControlCallback(Step8Custom3Callback);
    Step9Custom3.setControlCallback(Step9Custom3Callback);
    Step10Custom3.setControlCallback(Step10Custom3Callback);
    Step11Custom3.setControlCallback(Step11Custom3Callback);
    Step12Custom3.setControlCallback(Step12Custom3Callback);
    Step13Custom3.setControlCallback(Step13Custom3Callback);
    Step14Custom3.setControlCallback(Step14Custom3Callback);
    Step15Custom3.setControlCallback(Step15Custom3Callback);
    Step16Custom3.setControlCallback(Step16Custom3Callback);

    // Defaults
    updateBpmLabel();

    DirForward.setValue(1);
    directionMode = 0;

    RandAmount.setValue(100);
    randomAmount = 100;

    OctaveRange.setValue(2);
    octaveRange = 2;
    OctaveRangeCallback(OctaveRange, OctaveRange.getValue());

    updateStartButtonLook();
}

// Run init and clear LEDs
onInit();
clearStepLeds();

// Dummy callbacks so HISE is happy
function onNoteOn()
{
	
}
 function onNoteOff()
{
	
}
 function onController()
{
	
}
 function onTimer()
{
	
}
 function onControl(number, value)
{
	
}
 